/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installagent;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.install.BooleanHolder;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.LoggingCommandErrorHandler;
import com.mathworks.install.Product;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.condition.Condition;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install_core_common.AbstractMathworksInstallConfiguration;
import com.mathworks.installagent.InstallAgentResourceKeys;
import com.mathworks.installagent.MCRInstallConfiguration;
import com.mathworks.installagent.UserAppInstallationProperties;
import com.mathworks.installagent.UserAppUninstallInstallConfiguration;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Platform;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public final class InstallAgentInstallConfiguration
extends MCRInstallConfiguration {
    private static final String INSTALLBUNDLE_NAME_FOR_UNINSTALLER = "installbundle.zip";
    private List<Command> postInstallCommandList = Collections.emptyList();
    private UserAppInstallationProperties userAppInstallationProperties;
    private InstallConfigurationPersistence installConfigurationPersistence;
    private boolean installingUserApp = false;
    private boolean createUninstallFolder = false;
    private String shortcutTarget;
    private final BooleanHolder isPathTooLong = new BooleanHolder(false);

    @Inject(optional=true)
    public void setUserAppInstallProperties(UserAppInstallationProperties userAppInstallationProperties) {
        this.userAppInstallationProperties = userAppInstallationProperties;
        this.installingUserApp = true;
        this.shortcutTarget = userAppInstallationProperties.getShortCutPath();
    }

    @Inject(optional=true)
    public void setPostInstallCommandList(@Named(value="PostInstallCommands") List<Command> list) {
        this.postInstallCommandList = list;
    }

    @Inject(optional=true)
    public void setInstallConfigurationPersistence(InstallConfigurationPersistence installConfigurationPersistence) {
        this.installConfigurationPersistence = installConfigurationPersistence;
    }

    @Inject(optional=true)
    public void setPlatform(Platform platform) {
        if (platform.isWindows()) {
            this.createUninstallFolder = true;
        }
    }

    @Override
    public final Command[] getAdditionalPostInstallCommands(String string, Product[] productArray, CommandFactory commandFactory, ServiceFactory serviceFactory, IO iO, Properties properties) {
        String string2;
        IOFileFilter iOFileFilter;
        String string3 = properties.getProperty("root");
        ArrayList<Command> arrayList = new ArrayList<Command>();
        String string4 = InstallAgentInstallConfiguration.buildPath("bin", string);
        String string5 = InstallAgentInstallConfiguration.buildPath("runtime", string);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string5);
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_Base_Product})) {
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(Paths.get(string3, "java", "config", "installagent").toString(), Paths.get("uninstall", "java", "config", "installagent").toString(), (FilenameFilter)FileFilterUtils.nameFileFilter((String)"pathlist.jar")));
        }
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_Base_Product})) {
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(Paths.get(string3, "java", "config", "default").toString(), Paths.get("java", "config", "default").toString(), (FilenameFilter)FileFilterUtils.suffixFileFilter((String)"config")));
        }
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_Base_Product})) {
            arrayList.add(commandFactory.createInsertPathIntoSystemPathCommand(string5, "", this.isPathTooLong));
        }
        if (this.checkIfOnWindowsAndAllConditionsSatisfied(string, Arrays.asList(productArray), new Condition[]{AbstractMathworksInstallConfiguration.MatlabRuntimeProductConditions.MATLAB_Runtime_NET_Product})) {
            iOFileFilter = new ArrayList();
            string2 = InstallAgentInstallConfiguration.buildPath("toolbox", "dotnetbuilder", "bin", string, "v4.0");
            iOFileFilter.add(commandFactory.createInstallAssemblyFilesCommand(string2, new String[]{"MWArray.dll"}));
            iOFileFilter.add(commandFactory.createRegisterAssemblyFolderCommand("DotNetBuilder", string2));
            arrayList.add(commandFactory.createAssemblyFrameworkCommand(InstallAgentResourceKeys.DOT_NET_BUILDER_MCR_WARNING.getString(new Object[0]), (CommandErrorHandler)new LoggingCommandErrorHandler(), iOFileFilter.toArray(new Command[iOFileFilter.size()])));
            arrayList.add(commandFactory.createRegisterDllsWithPathsCommand(string4, arrayList2, new String[]{"mwcomutil.dll", "mwcommgr.dll"}));
        }
        arrayList.addAll(this.postInstallCommandList);
        if (this.installingUserApp) {
            iOFileFilter = FileFilterUtils.fileFileFilter();
            string2 = ((File)this.userAppInstallationProperties.getUserAppInstallLocationModel().get()).getAbsolutePath();
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(InstallAgentInstallConfiguration.buildPath(string3, "bin", string), InstallAgentInstallConfiguration.buildPath(string2, "uninstall", "bin", string), (FilenameFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".ocx"), FileFilterUtils.suffixFileFilter((String)".dll")})));
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(InstallAgentInstallConfiguration.buildPath(string3, "utils", "uninstall", "bin", string), InstallAgentInstallConfiguration.buildPath(string2, "uninstall", "bin", string), (FilenameFilter)iOFileFilter));
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(InstallAgentInstallConfiguration.buildPath(string3, "java"), InstallAgentInstallConfiguration.buildPath(string2, "uninstall", "java"), (FilenameFilter)FileFilterUtils.trueFileFilter()));
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(InstallAgentInstallConfiguration.buildPath(string3, "sys"), InstallAgentInstallConfiguration.buildPath(string2, "sys"), (FilenameFilter)FileFilterUtils.trueFileFilter()));
            arrayList.add(commandFactory.createCopyFilesToInstallationCommand(string3, InstallAgentInstallConfiguration.buildPath(string2, "uninstall"), (FilenameFilter)FileFilterUtils.nameFileFilter((String)"VersionInfo.xml")));
            if (this.createUninstallFolder) {
                arrayList.add(commandFactory.createWriteInstallConfigurationCommandToLocation(this.installConfigurationPersistence, (InstallConfiguration)new UserAppUninstallInstallConfiguration(), (File)this.userAppInstallationProperties.getUserAppInstallLocationModel().get()));
            }
            arrayList.add(commandFactory.createCopyFileToDirectoryCommand(this.userAppInstallationProperties.getBundle(), InstallAgentInstallConfiguration.buildPath(string2, "uninstall"), INSTALLBUNDLE_NAME_FOR_UNINSTALLER));
            arrayList.add(commandFactory.createRegisterUninstallerForUserAppCommand(this.userAppInstallationProperties.getApplicationName(), this.userAppInstallationProperties.getAuthorOrganizationText(), this.userAppInstallationProperties.getVersion(), InstallAgentInstallConfiguration.buildPath(((File)this.userAppInstallationProperties.getUserAppInstallLocationModel().get()).getAbsolutePath(), this.userAppInstallationProperties.getAddRemoveProgramIcon()), InstallAgentInstallConfiguration.buildPath(((File)this.userAppInstallationProperties.getUserAppInstallLocationModel().get()).getAbsolutePath(), "uninstall", "bin", string, "uninstall.exe"), ((File)this.userAppInstallationProperties.getUserAppInstallLocationModel().get()).getAbsolutePath(), this.userAppInstallationProperties.getSummaryText()));
            if (!this.userAppInstallationProperties.getRegisterDllPath().isEmpty()) {
                arrayList.add(commandFactory.createRegisterDllsWithPathsCommand(string2, arrayList2, new String[]{this.userAppInstallationProperties.getRegisterDllPath()}));
            }
        }
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    private Command getCreateDesktopShortcutCommand(CommandFactory commandFactory, String string) {
        return commandFactory.createDesktopShortcutCommand(((File)this.userAppInstallationProperties.getUserAppInstallLocationModel().get()).getAbsolutePath(), string, this.userAppInstallationProperties.getApplicationName(), "", this.userAppInstallationProperties.getApplicationName(), false, false);
    }

    private Command getCreateStartMenuShortcutCommand(CommandFactory commandFactory, String string) {
        return commandFactory.createStartMenuShortcutCommand(((File)this.userAppInstallationProperties.getUserAppInstallLocationModel().get()).getAbsolutePath(), string, this.userAppInstallationProperties.getApplicationName(), "", "", this.userAppInstallationProperties.getApplicationName(), false, false, false);
    }

    @Override
    public final void deactivateInstallation(String string, Product[] productArray, String[] stringArray) {
        throw new UnsupportedOperationException("Can't deactivate this installer");
    }

    @Override
    public final void activateInstallation(String[] stringArray) {
        throw new UnsupportedOperationException("Can't activate this installer");
    }

    public boolean shouldAddCommandsForOptions(Product[] productArray) {
        return true;
    }

    @Override
    public Command[] createStartMenuShortcutCommands(CommandFactory commandFactory, InstallerRequirements installerRequirements, Platform platform) {
        Command[] commandArray = new Command[]{};
        if (platform.isWindows()) {
            Command command = this.getCreateStartMenuShortcutCommand(commandFactory, this.shortcutTarget);
            commandArray = new Command[]{command};
        }
        return commandArray;
    }

    @Override
    public Command[] createDesktopShortcutCommands(String string, CommandFactory commandFactory, InstallerRequirements installerRequirements) {
        return new Command[]{this.getCreateDesktopShortcutCommand(commandFactory, this.shortcutTarget)};
    }
}

