/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.service.Service;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Properties;

final class WindowsInstallOptionsWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Installer installer;
    private final File installationFolder;
    private final InstallWizardContext installWizardContext;
    private final ValidatedFik validatedFik;
    private final Model<Boolean> lnuOnly;
    private final InstallOption[] installOptions;
    private InstallOptionModel desktopOption;
    private InstallOptionModel startMenuOption;
    private boolean installingLicenseService;
    private InstallOptionModel licenseServiceOption;
    private final Service licenseManagerService;
    private LicenseLocationFactory licenseLocationFactory;
    private final Model<String> jitInstallModel;
    private final Model<MinimalProducts> minimalProducts;

    WindowsInstallOptionsWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray, Service service, LicenseLocationFactory licenseLocationFactory, Model<Boolean> model, Model<String> model2, Model<MinimalProducts> model3) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installer = installer;
        this.installationFolder = file;
        this.installWizardContext = installWizardContext;
        this.validatedFik = validatedFik;
        this.lnuOnly = model;
        this.installOptions = (InstallOption[])installOptionArray.clone();
        this.licenseManagerService = service;
        this.licenseLocationFactory = licenseLocationFactory;
        this.jitInstallModel = model2;
        this.minimalProducts = model3;
        block7: for (InstallOption installOption : this.installOptions) {
            switch (installOption.getType()) {
                case DESKTOP_SHORTCUT: {
                    this.desktopOption = installModelFactory.createDesktopOptionModel(installOption);
                    continue block7;
                }
                case POLYSPACE_SHORTCUT: {
                    this.desktopOption = installModelFactory.createDesktopOptionModel(installOption);
                    continue block7;
                }
                case START_MENU_SHORTCUT: {
                    this.startMenuOption = installModelFactory.createStartMenuOptionModel(installOption);
                    continue block7;
                }
                case POLYSPACE_START_MENU_SHORTCUT: {
                    this.startMenuOption = installModelFactory.createStartMenuOptionModel(installOption);
                    continue block7;
                }
                case LICENSE_SERVICE: {
                    this.installingLicenseService = true;
                    this.licenseServiceOption = installModelFactory.createLicenseServiceModel(installOption);
                }
            }
        }
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createShowMinimalProductNoteStep(this.installer, this.minimalProducts));
        if (this.installingLicenseService) {
            String string = this.licenseLocationFactory.getNetworkServerLicenseLocation(this.installationFolder.getAbsolutePath()).getLicenseLocation();
            this.addStep(panelStepBuilder.buildLicenseServicePanelStep(this.licenseServiceOption, this.licenseManagerService.getDisplayName(), this.licenseManagerService.getLocation(this.installationFolder), new File(string)));
            this.addStep(installCommandStepFactory.createValidateLicenseServerSelectionStep(this.licenseServiceOption, this.licenseManagerService, this.installationFolder));
        }
        this.addStep(panelStepBuilder.buildWindowsInstallationOptionsStep(this.desktopOption, this.startMenuOption));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InstallOption installOption : this.installOptions) {
            stringBuilder.append(installOption.getContext()).append(installOption.isSelected());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createInstallationWorkflow(this.installer, this.installationFolder, this.installWizardContext, properties, this.validatedFik, this.installOptions, this.lnuOnly, this.jitInstallModel);
    }
}

