/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class PreProductSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final InstallModelFactory modelFactory;
    private final FileSystem fileSystem;
    private final Model<Boolean> lnuOnly;
    private final Installer install;
    private final ValidatedFik validatedFik;
    private InstallWizardContext installWizardContext;
    private final DefaultedModel<String> folderModel;
    private Model<ProductModel<AvailableProduct>> productModelModel;
    private Model<ProductTableFormat<AvailableProduct>> productTableFormatModel;
    private final Model<String> jitInstallModel;
    private final Model<MinimalProducts> minimalProducts;

    PreProductSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, Installer installer, ValidatedFik validatedFik, InstallWizardContext installWizardContext, DefaultedModel<String> defaultedModel, FileSystem fileSystem, Model<Boolean> model, Model<String> model2, Model<MinimalProducts> model3) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installWizardContext = installWizardContext;
        this.folderModel = defaultedModel;
        this.fileSystem = fileSystem;
        this.lnuOnly = model;
        this.install = installer;
        this.validatedFik = validatedFik;
        this.modelFactory = installModelFactory;
        this.productModelModel = new ModelImpl();
        this.productTableFormatModel = new ModelImpl();
        this.jitInstallModel = model2;
        this.minimalProducts = model3;
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createUpdateAvailableProductsByMinimalProductList(this.install, this.modelFactory, this.minimalProducts));
        this.addStep(installCommandStepFactory.createInstalledProductModelStep(this.install, this.folderModel, this.modelFactory, this.productModelModel));
        this.addStep(installCommandStepFactory.createInstallProductTableFormat(this.productModelModel, this.install, this.modelFactory, this.productTableFormatModel));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setRoot((String)this.folderModel.get());
        return this.getText();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createProductSelectionWorkflow(properties, this.install, this.validatedFik, this.installWizardContext, this.folderModel, this.fileSystem, this.lnuOnly, this.productTableFormatModel, this.productModelModel, this.jitInstallModel);
    }

    private String getText() {
        String string = System.getProperty("line.separator");
        return WizardResourceKeys.CONFIRM_DIR.getString(new Object[0]) + string + (String)this.folderModel.get();
    }
}

