/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Installer;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.util.Properties;

final class PostFolderSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final DefaultedModel<String> installFolderModel;
    private final FileSystem fileSystem;
    private final Model<Installer> installerModel;
    private final Model<Boolean> lnuOnly;
    private final Model<String> jitInstallModel;
    private Model<ValidatedFik> validatedFik;
    private InstallWizardContext installWizardContext;

    PostFolderSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, Model<ValidatedFik> model, InstallWizardContext installWizardContext, Model<Boolean> model2, Model<String> model3, DefaultedModel<String> defaultedModel, Model<Installer> model4) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.validatedFik = model;
        this.installWizardContext = installWizardContext;
        this.lnuOnly = model2;
        this.installFolderModel = defaultedModel;
        this.installerModel = model4;
        this.fileSystem = installModelFactory.createFileSystem((SoftwareManager)model4.get(), defaultedModel);
        this.jitInstallModel = model3;
    }

    @Override
    protected final void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.resetAndDeselectOlderVersionsOfSelectedProducts(this.installerModel));
        this.addStep(installCommandStepFactory.createCheckIfOverwriteImpossibleStep(this.installFolderModel, this.installerModel));
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return !((Installer)PostFolderSelectionWorkflow.this.installerModel.get()).isPolyspaceInstallation();
            }
        }, new Step[]{installCommandStepFactory.createWarningMessageIfMATLABRunning(this.installFolderModel)});
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
    }

    @Override
    protected final String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setRoot((String)this.installFolderModel.get());
        return (String)this.installFolderModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createPreProductSelectionWorkflow(properties, (Installer)this.installerModel.get(), (ValidatedFik)this.validatedFik.get(), this.installWizardContext, this.installFolderModel, this.fileSystem, this.lnuOnly, this.jitInstallModel);
    }
}

