/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.Properties;

final class OnlineHasFikWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Model<String> loginToken;
    private final Model<ValidatedFik> validatedFik;
    private final Model<String> enteredFik;
    private final InstallWizardContext context;
    private final LicenseNumberProvider licenseNumberProvider;
    private final Model<MWAEntitlement> entitlement;
    private final Model<Boolean> lnuOnly;
    private final Model<String> jitInstallModel;
    private final UsageDataCollector usageDataCollector;
    private final Model<MinimalProducts> minimalProducts;
    private final Model<Product[]> productListModel;

    OnlineHasFikWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, String string, String string2, InstallWizardContext installWizardContext, Properties properties, Model<MWAEntitlement> model, LicenseNumberProvider licenseNumberProvider, UsageDataCollector usageDataCollector, Model<MinimalProducts> model2) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.enteredFik = new ModelImpl((Object)string);
        this.context = installWizardContext;
        this.lnuOnly = new ModelImpl((Object)false);
        this.entitlement = model;
        this.loginToken = new ModelImpl((Object)string2);
        this.validatedFik = new ModelImpl();
        this.jitInstallModel = new ModelImpl((Object)"");
        this.licenseNumberProvider = licenseNumberProvider;
        this.usageDataCollector = usageDataCollector;
        this.minimalProducts = model2;
        this.productListModel = new ModelImpl();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createFinishReadingArchivesStep());
        this.addStep(installCommandStepFactory.createConvertKeyToValidFikStep(this.enteredFik, this.validatedFik));
        this.addStep(installCommandStepFactory.createIsLNUOnlyStep(this.entitlement, this.lnuOnly));
        this.addStep(installCommandStepFactory.createUpdateLicenseProviderStep(this.entitlement, this.licenseNumberProvider));
        this.addStep(installCommandStepFactory.createCheckJitOrTeuEnabledEntitlementStep(this.entitlement, this.jitInstallModel, this.validatedFik, this.licenseNumberProvider));
        this.addStep(installCommandStepFactory.createGetMinimalProductsListStep(this.loginToken, this.entitlement, this.minimalProducts));
        this.addStep(installCommandStepFactory.createProductListFromFIK(this.validatedFik, this.productListModel));
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (!((String)this.jitInstallModel.get()).isEmpty()) {
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_JIT_USER_TYPE, this.jitInstallModel.get());
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_JIT_LICENSE_NUMBER_USED, (Object)this.licenseNumberProvider.getLicenseNumber());
        }
        return installWorkflowFactory.createOnlineFolderSelectionWorkflow(properties, this.validatedFik, this.context, this.lnuOnly, this.jitInstallModel, this.entitlement, this.loginToken, this.productListModel);
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return (String)this.enteredFik.get();
    }
}

