/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.util.Properties;

final class OnlineFolderSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final DefaultedModel<String> installFolderModel;
    private final DefaultedModel<String> displayedFolderModel;
    private final Model<ValidatedFik> validatedFik;
    private final InstallWizardContext installWizardContext;
    private final Model<Boolean> lnuOnly;
    private final Properties installerProperties;
    private final Model<String> jitInstallModel;
    private final Model<MWAEntitlement> entitlement;
    private final Model<String> loginToken;
    private final String installerRoot;

    OnlineFolderSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, Model<ValidatedFik> model, InstallWizardContext installWizardContext, Model<Boolean> model2, Properties properties2, Model<String> model3, Model<MWAEntitlement> model4, Model<String> model5, Model<Product[]> model6) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.validatedFik = model;
        this.installWizardContext = installWizardContext;
        this.lnuOnly = model2;
        this.installerProperties = properties2;
        this.installerRoot = properties2.getProperty(PropertyKey.ROOTDIR.get());
        this.entitlement = model4;
        this.loginToken = model5;
        this.installFolderModel = installModelFactory.createInstallFolderModel((Product[])model6.get());
        this.displayedFolderModel = installModelFactory.createDisplayedFolderModel(this.installFolderModel, (Product[])model6.get());
        this.jitInstallModel = model3;
    }

    @Override
    protected final void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(panelStepBuilder.buildFolderSelectionStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.installFolderModel));
        this.addStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.displayedFolderModel));
        this.addStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.installFolderModel));
        Condition condition = new Condition(){

            public boolean isSatisfied() {
                return OnlineFolderSelectionWorkflow.this.installerProperties.getProperty(PropertyKey.MODE.get(), "interactive").equals("interactive");
            }
        };
        this.addConditionalSteps(condition, new Step[]{installCommandStepFactory.createCheckInvalidInstallationDirectoryStep(this.installFolderModel)});
        this.addStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.installFolderModel));
        this.addStep(installCommandStepFactory.createCheckWritePermissionsStep(this.installFolderModel));
        this.addStep(installCommandStepFactory.createCheckIfIncompatibleUpdateSource(this.installFolderModel, this.installerRoot));
    }

    @Override
    protected final String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setRoot((String)this.installFolderModel.get());
        return (String)this.installFolderModel.get();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createDWSWorkflow(properties, this.validatedFik, this.installWizardContext, this.entitlement, this.lnuOnly, this.jitInstallModel, this.loginToken, this.installFolderModel);
    }
}

