/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.Platform;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.util.Properties;

public final class LoginVerificationWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private static final MWAEntitlement[] EMPTY_ENTITLEMENT_ARRAY = new MWAEntitlement[0];
    private final Model<MWAEntitlement[]> entitlements;
    private final Model<Boolean> adminSwitch;
    private final Model<Boolean> installSwitch;
    private final UsageDataCollector usageDataCollector;
    private final String clientString;
    private final Platform platform;
    private final Model<Boolean> enableDLSwitch;
    private final Model<String> hasExcessEntitlements;
    private final Model<Boolean> requiresCodeVerificationModel;
    private final Model<String> verificationCode;
    private final Model<String> twoSVMessage;
    private final Model<String> token;

    LoginVerificationWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, Model<String> model, Model<Boolean> model2, Model<String> model3, UsageDataCollector usageDataCollector, String string, String string2, Platform platform) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.token = model;
        this.requiresCodeVerificationModel = model2;
        this.twoSVMessage = model3;
        this.usageDataCollector = usageDataCollector;
        this.clientString = string2;
        this.platform = platform;
        this.entitlements = new ModelImpl((Object)EMPTY_ENTITLEMENT_ARRAY);
        this.adminSwitch = new ModelImpl();
        this.installSwitch = installModelFactory.createInstallSwitch();
        this.enableDLSwitch = installModelFactory.createEnableDLSwitchModel(string);
        this.hasExcessEntitlements = new ModelImpl((Object)"");
        this.verificationCode = new ModelImpl((Object)"");
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return (Boolean)LoginVerificationWorkflow.this.requiresCodeVerificationModel.get();
            }
        }, new Step[]{panelStepBuilder.build2SVStep(this.clientString, this.platform, this.token, this.twoSVMessage, this.verificationCode)});
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return (Boolean)LoginVerificationWorkflow.this.requiresCodeVerificationModel.get();
            }
        }, new Step[]{installCommandStepFactory.createLoginVerificationStep(this.token, this.verificationCode, this.requiresCodeVerificationModel)});
        this.addStep(installCommandStepFactory.createGetEntitlementsStep(this.token, this.entitlements, this.hasExcessEntitlements));
        this.addStep(installCommandStepFactory.createIsDownloadOnlyPermissionAvailableStep(this.entitlements, this.adminSwitch, this.enableDLSwitch));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        installWizardProperties.setToken((String)this.token.get());
        StringBuilder stringBuilder = new StringBuilder();
        for (MWAEntitlement mWAEntitlement : (MWAEntitlement[])this.entitlements.get()) {
            stringBuilder.append(mWAEntitlement.getId());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_TOKEN, this.token.get());
        if (((Boolean)this.adminSwitch.get()).booleanValue() || !((String)this.hasExcessEntitlements.get()).isEmpty()) {
            return installWorkflowFactory.createDownloadInstallWorkflow(properties, this.installSwitch, this.entitlements, this.token, this.hasExcessEntitlements);
        }
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_DOWNLOAD_ONLY, (Object)false);
        if (this.foundEntitlements()) {
            return installWorkflowFactory.createEntitlementSelectionWorkflow((MWAEntitlement[])this.entitlements.get(), (String)this.token.get(), properties);
        }
        return installWorkflowFactory.createProvideActivationKeyWorkflow((String)this.token.get(), properties);
    }

    private boolean foundEntitlements() {
        return ((MWAEntitlement[])this.entitlements.get()).length > 0;
    }
}

