/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.InstallOption;
import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallOptionModelAdapter;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.io.File;
import java.util.Properties;

public class LinuxInstallOptionsWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final Installer installer;
    private final File installFolder;
    private final InstallWizardContext installWizardContext;
    private final ValidatedFik validatedFik;
    private final InstallOption[] installOptions;
    private final Model<Boolean> lnuOnly;
    private InstallOptionModel symbolicLinkOption;
    private DefaultedModel<String> symbolicLinkModel;
    private final Model<String> jitInstallModel;
    private final Model<MinimalProducts> minimalProducts;

    public LinuxInstallOptionsWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Installer installer, File file, InstallWizardContext installWizardContext, Properties properties, ValidatedFik validatedFik, InstallOption[] installOptionArray, Model<Boolean> model, Model<String> model2, Model<MinimalProducts> model3) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installer = installer;
        this.installFolder = file;
        this.installWizardContext = installWizardContext;
        this.validatedFik = validatedFik;
        this.installOptions = installOptionArray;
        this.lnuOnly = model;
        this.jitInstallModel = model2;
        this.minimalProducts = model3;
        for (InstallOption installOption : installOptionArray) {
            switch (installOption.getType()) {
                case SYMBOLIC_LINK: {
                    this.symbolicLinkOption = installModelFactory.createSymbolicLinkOptionModel(installOption);
                    this.symbolicLinkModel = new InstallOptionModelAdapter(this.symbolicLinkOption);
                }
            }
        }
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createShowMinimalProductNoteStep(this.installer, this.minimalProducts));
        this.addStep(panelStepBuilder.buildLinuxInstallationOptionsStep(this.symbolicLinkOption));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckPathForNonEnglishCharactersStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckPathForInvalidCharactersStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createVerifyRootDirectoryStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckPathForExistenceStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCreateFolderIfItDoesNotAlreadyExistStep(this.symbolicLinkModel));
        this.addSymbolicLinkStep(installCommandStepFactory.createCheckSymbolicLinkCreationPermissionsStep(this.symbolicLinkModel));
    }

    private void addSymbolicLinkStep(Step step) {
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return LinuxInstallOptionsWorkflow.this.symbolicLinkModel != null && LinuxInstallOptionsWorkflow.this.symbolicLinkOption.isSelected();
            }
        }, new Step[]{step});
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InstallOption installOption : this.installOptions) {
            stringBuilder.append(installOption.getContext()).append(installOption.isSelected());
        }
        return stringBuilder.toString();
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createInstallationWorkflow(this.installer, this.installFolder, this.installWizardContext, properties, this.validatedFik, this.installOptions, this.lnuOnly, this.jitInstallModel);
    }
}

