/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Installer;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.Condition;
import java.util.Properties;

final class HasFikWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    protected final Model<ValidatedFik> validatedFik = new ModelImpl();
    private final Model<String> enteredFik;
    protected final Model<Installer> installerModel = new ModelImpl();
    private final InstallWizardContext context;
    protected ModelImpl<Boolean> lnuOnly;
    private Model<String> jitInstallModel;
    private LicenseNumberProvider licenseNumberProvider;
    private final UsageDataCollector usageDataCollector;
    private final Model<MinimalProducts> minimalProducts;
    private Model<Boolean> isDDUXPingable;
    private final String token = "8d12fc5b-5fe5-4643-9b52-10faf10df251";
    private final Properties installerProperties;

    HasFikWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, String string, InstallWizardContext installWizardContext, Properties properties, LicenseNumberProvider licenseNumberProvider, UsageDataCollector usageDataCollector, Model<MinimalProducts> model, Properties properties2) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.usageDataCollector = usageDataCollector;
        this.licenseNumberProvider = licenseNumberProvider;
        this.enteredFik = new ModelImpl((Object)string);
        this.context = installWizardContext;
        this.lnuOnly = new ModelImpl((Object)false);
        this.isDDUXPingable = new ModelImpl((Object)false);
        this.jitInstallModel = new ModelImpl((Object)"");
        this.minimalProducts = model;
        this.installerProperties = properties2;
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return HasFikWorkflow.this.installerProperties.getProperty("disablefikddux") == null;
            }
        }, new Step[]{installCommandStepFactory.createGetDDUXPingCallableStep(this.isDDUXPingable)});
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return (Boolean)HasFikWorkflow.this.isDDUXPingable.get();
            }
        }, new Step[]{installCommandStepFactory.createGetDDUXSettingsCallableStepForFik("8d12fc5b-5fe5-4643-9b52-10faf10df251")});
        this.addStep(installCommandStepFactory.createResetMinimalProductMode(this.minimalProducts));
        this.addStep(installCommandStepFactory.createConvertKeyToValidFikStep(this.enteredFik, this.validatedFik));
        this.addStep(installCommandStepFactory.createFinishReadingArchivesStep());
        this.addStep(installCommandStepFactory.createBuildInstallerStep(this.validatedFik, this.installerModel));
        this.addStep(installCommandStepFactory.createCheckJitOrTeuEnabledFikStep(this.validatedFik, this.jitInstallModel, this.licenseNumberProvider));
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return !((String)HasFikWorkflow.this.jitInstallModel.get()).isEmpty() && !HasFikWorkflow.this.licenseNumberProvider.getLicenseUse().isEmpty();
            }
        }, new Step[]{panelStepBuilder.buildLicenseNumberStep(this.licenseNumberProvider)});
        this.addStep(installCommandStepFactory.createCheckIfNoProductsInFIKFlowStep(this.installerModel));
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        if (!((String)this.jitInstallModel.get()).isEmpty()) {
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_JIT_LICENSE_NUMBER_USED, (Object)this.licenseNumberProvider.getLicenseNumber());
        }
        return installWorkflowFactory.createFolderSelectionWorkflow(this.installerModel, properties, (ValidatedFik)this.validatedFik.get(), this.context, (Model<Boolean>)this.lnuOnly, this.jitInstallModel);
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return (String)this.enteredFik.get();
    }
}

