/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.install.Downloader;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.workflow.v2.AbstractSimpleInstallWorkflow;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.DefaultedModelImpl;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;

final class DownloadConfirmationPanelWorkflow
extends AbstractSimpleInstallWorkflow {
    private final FileSystem fileSystem;
    private final String confirmationText;
    private final BackgroundTask downloadTask;
    private final int downloadSize;
    private final Model<CheckBoxConfiguration> openLocationCheckBoxConfigurationModel;
    private final File downloadFile;
    private DefaultedModel<File> downloadFolderModel;
    private Downloader downloader;

    DownloadConfirmationPanelWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, Downloader downloader, InstallWizardContext installWizardContext, DefaultedModel<File> defaultedModel, FileSystem fileSystem, PlatformModel<AvailablePlatform> platformModel) {
        super(installCommandStepFactory);
        this.downloader = downloader;
        this.downloadFile = (File)defaultedModel.get();
        this.downloadFolderModel = defaultedModel;
        this.fileSystem = fileSystem;
        this.confirmationText = installWizardContext.buildDownloadConfirmationText(this.downloadFile, downloader, platformModel);
        long l = downloader.getDownloadSize(this.downloadFile);
        this.downloadSize = Long.valueOf(l / 0x100000L).intValue();
        this.downloadTask = installModelFactory.createDownloadTask((SoftwareManager)downloader, this.downloadFile);
        this.openLocationCheckBoxConfigurationModel = installModelFactory.createOpenCheckBoxConfigurationModel();
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(installCommandStepFactory.createCheckProductDependenciesStep((SoftwareManager)this.downloader, (DefaultedModel<String>)new DefaultedModelImpl((Object)((File)this.downloadFolderModel.get()).getAbsolutePath())));
        this.addStep(installCommandStepFactory.createWarnIfNotEnoughAvailableSpaceStep(this.fileSystem));
        this.addStep(panelStepBuilder.buildDownloadConfirmationStep(this.confirmationText));
        this.addStep(installCommandStepFactory.createLoadFileListDataStep(this.downloadFile));
        this.addStep(installCommandStepFactory.createRunTaskStep(panelStepBuilder.buildStatusStep(this.downloadTask, false), this.downloadTask));
        this.addStep(panelStepBuilder.buildDownloadFinalPanelStep(this.downloadSize, this.downloadFile.getAbsolutePath(), this.openLocationCheckBoxConfigurationModel));
        this.addStep(installCommandStepFactory.createCloseUIStep());
        this.addStep(installCommandStepFactory.createOpenDownloadLocationStep(this.downloadFolderModel, this.openLocationCheckBoxConfigurationModel));
    }
}

