/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.uninstall.workflow;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.uninstall.workflow.UninstallFinalWorkflow;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.AbstractBranchingWorkflow;
import com.mathworks.wizard.workflow.Condition;
import java.io.File;
import java.util.Properties;

final class UninstallProductSelectionWorkflow
extends AbstractBranchingWorkflow {
    private final ProductModel<AvailableProduct> productModel;
    private final ProductTableFormat<AvailableProduct> productTableFormat;
    private final BackgroundTask uninstallTask;
    private final Installer install;
    private final InstallCommandStepFactory commandStepFactory;
    private final Properties cmdLineProperties;
    private final File installationFolder;
    private final InstallOptionModel[] deletePreferencesOptionModels;
    private final InstallOption[] uninstallOptions;
    private final Model<Boolean> showProductTableModel = new ModelImpl((Object)true);
    private final Model<Boolean> isControllingProductSelectedModel;

    UninstallProductSelectionWorkflow(SourcePathProvider sourcePathProvider, Installer installer, InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, Properties properties) {
        this.install = installer;
        this.commandStepFactory = installCommandStepFactory;
        this.cmdLineProperties = properties;
        this.uninstallOptions = installModelFactory.getUninstallOptions(installer.getAvailableProducts(), installer.getDefaultPreferencesOption());
        this.installationFolder = new File(sourcePathProvider.getSourcePath());
        this.productModel = installModelFactory.createProductModel((SoftwareManager)installer);
        installModelFactory.updateProductModelByBaseCodes((SoftwareManager)installer);
        this.productTableFormat = installModelFactory.createUninstallProductTableFormat(this.productModel, installer);
        this.uninstallTask = installModelFactory.createUninstallTask(installer, this.installationFolder);
        this.deletePreferencesOptionModels = installModelFactory.createDeletePreferencesOptionModels(this.uninstallOptions);
        for (InstallOption installOption : this.uninstallOptions) {
            if (!installOption.getType().equals((Object)InstallOptionType.NOT_SHOW_PRODUCT_TABLE)) continue;
            this.showProductTableModel.set((Object)false);
        }
        this.isControllingProductSelectedModel = new ModelImpl((Object)false);
    }

    protected void construct(PanelStepBuilder panelStepBuilder) {
        this.addStep(panelStepBuilder.buildUninstallerProductSelectionStep(this.productModel, this.productTableFormat, this.showProductTableModel, this.deletePreferencesOptionModels));
        this.addConditionalSteps(new Condition(){

            public boolean isSatisfied() {
                return !UninstallProductSelectionWorkflow.this.install.isPolyspaceInstallation();
            }
        }, new Step[]{this.commandStepFactory.createCheckUninstallerRequirementsStep()});
        this.addStep(this.commandStepFactory.createCheckUninstallerControllingProductStep(this.install, this.installationFolder));
        this.addStep(this.commandStepFactory.createCheckUninstallerProductDependenciesStep(this.install, this.installationFolder));
        this.addStep(this.commandStepFactory.createApplyUninstallOptionSelection(this.install, this.uninstallOptions));
        this.addStep(this.commandStepFactory.createRunTaskStep(panelStepBuilder.buildStatusStep(this.uninstallTask, true), this.uninstallTask));
        this.addStep(this.commandStepFactory.createDeleteDownloadedArchivesStep(this.productModel, this.installationFolder));
        this.addStep(this.commandStepFactory.createCheckIfControllingProductSelectedToBeUninstalledStep(this.productModel, this.isControllingProductSelectedModel));
    }

    public Workflow getBranch() {
        return new UninstallFinalWorkflow(this.install, this.installationFolder, this.cmdLineProperties, this.isControllingProductSelectedModel, this.commandStepFactory);
    }
}

