/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.uninstall.workflow;

import com.google.inject.Inject;
import com.mathworks.install.Installer;
import com.mathworks.install.XMLParseException;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.uninstall.workflow.UninstallProductSelectionWorkflow;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.workflow.AbstractBranchingWorkflow;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;

public final class InitialWorkflow
extends AbstractBranchingWorkflow {
    private final InstallCommandStepFactory instCommandStepFactory;
    private final InstallModelFactory instModelFactory;
    private final SourcePathProvider sourceProvider;
    private final ModelImpl<Installer> installerModel;
    private final File libDir;
    private Properties installProperties;

    @Inject
    InitialWorkflow(InstallCommandStepFactory installCommandStepFactory, InstallModelFactory installModelFactory, SourcePathProvider sourcePathProvider, File file, Properties properties) throws IOException, XMLParseException, ExecutionException, InterruptedException {
        this.instCommandStepFactory = installCommandStepFactory;
        this.instModelFactory = installModelFactory;
        this.sourceProvider = sourcePathProvider;
        this.installerModel = new ModelImpl();
        this.libDir = file;
        this.installProperties = properties;
    }

    protected void construct(PanelStepBuilder panelStepBuilder) {
        this.addStep(this.instCommandStepFactory.createLoadNativeLibrariesStep(this.libDir.getAbsolutePath()));
        this.addStep(this.instCommandStepFactory.createLoadFileListDataStep(new File(this.sourceProvider.getSourcePath())));
        this.addStep(this.instCommandStepFactory.createBuildUninstallerStep(this.sourceProvider, (Model<Installer>)this.installerModel));
    }

    public Workflow getBranch() {
        Installer installer = (Installer)this.installerModel.get();
        return new UninstallProductSelectionWorkflow(this.sourceProvider, installer, this.instModelFactory, this.instCommandStepFactory, this.installProperties);
    }
}

