/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.install.Installer;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.ArchiveExaminer;
import com.mathworks.installwizard.InstallWizardPropertyKey;
import com.mathworks.installwizard.model.DownloadTask;
import com.mathworks.installwizard.model.InstallTask;
import com.mathworks.installwizard.model.InstallTaskFactory;
import com.mathworks.installwizard.model.UninstallTask;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

final class InstallTaskFactoryImpl
implements InstallTaskFactory {
    private final Properties properties;
    private final WizardUI wizardUI;
    private final ExceptionHandler exceptionHandler;
    private final Collection<InstallStatusObserver> observers;
    private AppLogger appLogger;

    @Inject
    InstallTaskFactoryImpl(Properties properties, WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, @Named(value="installStatusObserver") InstallStatusObserver installStatusObserver) {
        this.appLogger = appLogger;
        this.properties = new Properties(properties);
        this.observers = new ArrayList<InstallStatusObserver>();
        this.observers.add(installStatusObserver);
        this.wizardUI = wizardUI;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public BackgroundTask createInstallTask(Installer installer, File file, File file2) {
        if (Boolean.parseBoolean(this.properties.getProperty(InstallWizardPropertyKey.COMPONENTDUPES.get(), "false"))) {
            this.observers.add((InstallStatusObserver)new ArchiveExaminer(file));
        }
        return new InstallTask(installer, file, file2, this.wizardUI, this.exceptionHandler, this.appLogger, this.observers.toArray(new InstallStatusObserver[this.observers.size()]));
    }

    @Override
    public BackgroundTask createDownloadTask(SoftwareManager softwareManager, File file) {
        ArrayList arrayList = new ArrayList();
        return new DownloadTask(softwareManager, file, this.wizardUI, this.exceptionHandler, this.appLogger, arrayList.toArray(new InstallStatusObserver[arrayList.size()]));
    }

    @Override
    public BackgroundTask createUninstallTask(Installer installer, File file) {
        return new UninstallTask(installer, file, this.wizardUI, this.exceptionHandler, this.appLogger, this.observers.toArray(new InstallStatusObserver[this.observers.size()]));
    }
}

