/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.AvailableProduct;
import com.mathworks.installwizard.model.AbstractAvailableProductTableFormat;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.model.ProductModel;

final class InstallProductTableFormat
extends AbstractAvailableProductTableFormat {
    InstallProductTableFormat(ProductModel<AvailableProduct> productModel) {
        super(productModel);
    }

    @Override
    protected String getProductNote(AvailableProduct availableProduct) {
        if (availableProduct.isInstalled()) {
            return ResourceKeys.INSTALLED.getString(new Object[0]);
        }
        if (this.toBeDownloaded(availableProduct)) {
            return ResourceKeys.DOWNLOAD_REQUIRED.getString(new Object[0]);
        }
        return "";
    }

    private boolean toBeDownloaded(AvailableProduct availableProduct) {
        return availableProduct.getDownloadSize() > 0L;
    }

    @Override
    public int getColumnCount() {
        if (this.productModel.isAnyDownloadableProductAvailable() || this.productModel.isAnyProductInstalled()) {
            return 3;
        }
        return 2;
    }
}

