/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.google.inject.Inject;
import com.mathworks.install.AvailableProduct;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install_core_common.util.InstallCoreCommonUtil;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.installwizard.InstallWizardPropertyKey;
import com.mathworks.installwizard.model.AvailableDownloadProductTableFormat;
import com.mathworks.installwizard.model.AvailableProductModel;
import com.mathworks.installwizard.model.EntitlementTableFormatImpl;
import com.mathworks.installwizard.model.InstallFileSystemFactory;
import com.mathworks.installwizard.model.InstallFolderModelFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallOptionModelImpl;
import com.mathworks.installwizard.model.InstallProductTableFormat;
import com.mathworks.installwizard.model.InstallTaskFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.model.InstallWizardPropertiesImpl;
import com.mathworks.installwizard.model.OfflineInstallWizardContext;
import com.mathworks.installwizard.model.OnlineInstallWizardContext;
import com.mathworks.installwizard.model.UninstallProductTableFormat;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.Registry;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.wizard.NormalizedProperties;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.model.AccessibleTableFormat;
import com.mathworks.wizard.model.ConnectionMode;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.DefaultedModelImpl;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.model.PlatformModelImpl;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

final class InstallModelFactoryImpl
implements InstallModelFactory {
    private static final String PRODUCT_PROPERTY_PREFIX = "product.";
    private static final String BASECODE_PROPERTY_PREFIX = "basecode.";
    private static final String PLATFORM_PROPERTY_PREFIX = "arch.";
    private static final String RELEASE_DESCRIPTION = InstutilResourceKeys.RELEASE_DESCRIPTION.getString(new Object[0]);
    private final Properties properties;
    private final InstallFileSystemFactory fileSystemFactory;
    private final InstallFolderModelFactory folderModelFactory;
    private final InstallTaskFactory taskFactory;
    private final InstallConfiguration installConfiguration;
    private final Platform platform;
    private final HyperlinkProvider hyperlinkProvider;
    private DefaultedModel<File> defaultDownloadFolderForInstall;
    private DefaultedModel<File> defaultDownloadFolderForDownload;

    @Inject
    InstallModelFactoryImpl(Properties properties, InstallFileSystemFactory installFileSystemFactory, InstallFolderModelFactory installFolderModelFactory, InstallTaskFactory installTaskFactory, InstallConfiguration installConfiguration, Platform platform, HyperlinkProvider hyperlinkProvider) {
        this.properties = new Properties(properties);
        this.fileSystemFactory = installFileSystemFactory;
        this.folderModelFactory = installFolderModelFactory;
        this.taskFactory = installTaskFactory;
        this.installConfiguration = installConfiguration;
        this.platform = platform;
        this.hyperlinkProvider = hyperlinkProvider;
        this.defaultDownloadFolderForInstall = null;
    }

    @Override
    public FileSystem createFileSystem(SoftwareManager softwareManager, DefaultedModel<String> defaultedModel) {
        return this.fileSystemFactory.createFileSystem(softwareManager, defaultedModel);
    }

    @Override
    public ProductTableFormat<AvailableProduct> createInstallProductTableFormat(ProductModel<AvailableProduct> productModel, Installer installer) {
        return new InstallProductTableFormat(productModel);
    }

    @Override
    public ProductTableFormat<AvailableProduct> createUninstallProductTableFormat(ProductModel<AvailableProduct> productModel, Installer installer) {
        return new UninstallProductTableFormat(productModel);
    }

    @Override
    public ProductTableFormat<AvailableProduct> createDownloadProductTableFormat(ProductModel<AvailableProduct> productModel) {
        return new AvailableDownloadProductTableFormat(productModel);
    }

    @Override
    public ProductModel<AvailableProduct> createProductModel(SoftwareManager softwareManager) {
        AvailableProductModel availableProductModel = new AvailableProductModel(softwareManager);
        Collection collection = availableProductModel.getAvailable();
        Properties properties = this.getProductsFromPropertiesMap();
        boolean bl = false;
        if (!properties.isEmpty()) {
            bl = true;
            for (AvailableProduct availableProduct : collection) {
                Object object = InstallModelFactoryImpl.getPropertyName(availableProduct);
                if (!properties.containsKey(object)) continue;
                properties.remove(object);
            }
        }
        boolean bl2 = false;
        if (bl && !properties.isEmpty()) {
            bl2 = true;
        }
        for (Object object : collection) {
            if (bl2) {
                object.setSelected(false);
                continue;
            }
            if (object.getProductNumber() == 0) {
                object.setSelected(Boolean.valueOf(this.properties.getProperty(InstallWizardPropertyKey.LMGR_FILES.get(), Boolean.toString(object.isSelected()))).booleanValue());
                continue;
            }
            if (!bl || this.properties.getProperty(InstallModelFactoryImpl.getPropertyName(object)) != null) continue;
            object.setSelected(false);
        }
        return availableProductModel;
    }

    private Properties getProductsFromPropertiesMap() {
        NormalizedProperties normalizedProperties = new NormalizedProperties();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(PRODUCT_PROPERTY_PREFIX, 0)) continue;
            normalizedProperties.setProperty(string, "");
        }
        return normalizedProperties;
    }

    @Override
    public ProductModel<AvailableProduct> createInstalledProductModel(Installer installer, DefaultedModel<String> defaultedModel) {
        ProductModel<AvailableProduct> productModel = this.createProductModel((SoftwareManager)installer);
        AvailableProduct[] availableProductArray = installer.getAvailableProductsAlreadyInstalled(new File((String)defaultedModel.get()));
        List<AvailableProduct> list = Arrays.asList(availableProductArray);
        Collection collection = productModel.getAvailable();
        InstallCoreCommonUtil.updateAvailableProductsWithInstalled((Collection)collection, list, (Properties)this.getProductsFromPropertiesMap());
        return productModel;
    }

    @Override
    public boolean checkIfMinimalModeIsReal(SoftwareManager softwareManager, Model<MinimalProducts> model) {
        AvailableProduct[] availableProductArray;
        boolean bl = false;
        for (AvailableProduct availableProduct : availableProductArray = softwareManager.getAvailableProducts()) {
            if (!((MinimalProducts)model.get()).getMinimalProductList().contains(availableProduct.getProductBaseCode())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            ArrayList arrayList = new ArrayList();
            ((MinimalProducts)model.get()).setMinimalProductList(arrayList);
        }
        return bl;
    }

    @Override
    public void updateAvailableProductsByMinimalProductList(SoftwareManager softwareManager, Model<MinimalProducts> model) {
        AvailableProduct[] availableProductArray;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (AvailableProduct availableProduct : availableProductArray = softwareManager.getAvailableProducts()) {
            availableProduct.setSelected(false);
            if (!((MinimalProducts)model.get()).getMinimalProductList().contains(availableProduct.getProductBaseCode()) || hashSet.contains(availableProduct.getProductNumber())) continue;
            availableProduct.setSelected(true);
            hashSet.add(availableProduct.getProductNumber());
        }
    }

    @Override
    public void updateProductModelByBaseCodes(SoftwareManager softwareManager) {
        Collection<AvailableProduct> collection = new AvailableProductModel(softwareManager).getAvailable();
        NormalizedProperties normalizedProperties = new NormalizedProperties();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith(PRODUCT_PROPERTY_PREFIX, 0)) {
                normalizedProperties.setProperty(string, "");
                continue;
            }
            if (!string.startsWith(BASECODE_PROPERTY_PREFIX, 0)) continue;
            normalizedProperties.setProperty(string, "");
        }
        boolean bl = false;
        if (!normalizedProperties.isEmpty()) {
            bl = true;
            for (AvailableProduct availableProduct : collection) {
                String string;
                Object object = InstallModelFactoryImpl.getPropertyName(availableProduct);
                if (normalizedProperties.containsKey(object)) {
                    normalizedProperties.remove(object);
                }
                if (!normalizedProperties.containsKey(string = this.getBaseCode(availableProduct))) continue;
                normalizedProperties.remove(string);
            }
        }
        boolean bl2 = false;
        if (bl && !normalizedProperties.isEmpty()) {
            bl2 = true;
        }
        for (Object object : collection) {
            if (bl2) {
                object.setSelected(false);
                continue;
            }
            if (object.getProductNumber() == 0) {
                object.setSelected(Boolean.valueOf(this.properties.getProperty(InstallWizardPropertyKey.LMGR_FILES.get(), Boolean.toString(object.isSelected()))).booleanValue());
                continue;
            }
            if (!bl || this.isProductNameOrBaseCodeExists((AvailableProduct)object)) continue;
            object.setSelected(false);
        }
    }

    private static String getPropertyName(AvailableProduct availableProduct) {
        return PRODUCT_PROPERTY_PREFIX + availableProduct.getName().replaceAll("[ -]", "_");
    }

    private String getBaseCode(AvailableProduct availableProduct) {
        return BASECODE_PROPERTY_PREFIX + availableProduct.getProductBaseCode();
    }

    private boolean isProductNameOrBaseCodeExists(AvailableProduct availableProduct) {
        boolean bl = true;
        if (this.properties.getProperty(InstallModelFactoryImpl.getPropertyName(availableProduct)) == null && this.properties.getProperty(this.getBaseCode(availableProduct)) == null) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Model<String> createFikModel() {
        return new ModelImpl((Object)this.properties.getProperty(InstallWizardPropertyKey.FILE_INSTALLATION_KEY.get(), ""));
    }

    @Override
    public Model<String> createUserNameModel() {
        return new ModelImpl((Object)this.properties.getProperty(InstallWizardPropertyKey.USERNAME.get(), ""));
    }

    @Override
    public Model<String> createPasswordModel() {
        return new ModelImpl((Object)this.properties.getProperty(InstallWizardPropertyKey.PASSWORD.get(), ""));
    }

    @Override
    public DefaultedModel<File> createDownloadFolderModelForInstallWorkflow() {
        if (this.defaultDownloadFolderForInstall == null) {
            String string = System.getenv(ResourceKeys.MW_FOLDER_LOCATION.getString(new Object[0]));
            if (string == null || string.isEmpty()) {
                String string2 = FileUtils.getFile((String[])new String[]{System.getProperty("java.io.tmpdir"), "tmw" + Calendar.getInstance().getTimeInMillis()}).getAbsolutePath();
                this.defaultDownloadFolderForInstall = new DefaultedModelImpl((Object)FileUtils.getFile((String[])new String[]{this.properties.getProperty(InstallWizardPropertyKey.DOWNLOAD_FOLDER.get(), string2)}));
            } else {
                this.defaultDownloadFolderForInstall = new DefaultedModelImpl((Object)FileUtils.getFile((String[])new String[]{string, File.separator + "tmw" + Calendar.getInstance().getTimeInMillis()}));
            }
        }
        return this.defaultDownloadFolderForInstall;
    }

    @Override
    public DefaultedModel<File> createDownloadFolderModelForDownloadWorkflow() {
        if (this.defaultDownloadFolderForDownload == null) {
            String string = System.getenv(ResourceKeys.MW_FOLDER_LOCATION.getString(new Object[0]));
            if (string == null || string.isEmpty()) {
                FolderUtilsImpl folderUtilsImpl = new FolderUtilsImpl();
                String string2 = FileUtils.getFile((String[])new String[]{folderUtilsImpl.getDownloadFolder(), RELEASE_DESCRIPTION}).getAbsolutePath();
                this.defaultDownloadFolderForDownload = new DefaultedModelImpl((Object)FileUtils.getFile((String[])new String[]{this.properties.getProperty(InstallWizardPropertyKey.DOWNLOAD_FOLDER.get(), string2)}));
            } else {
                this.defaultDownloadFolderForDownload = new DefaultedModelImpl((Object)FileUtils.getFile((String[])new String[]{string, File.separator + "tmw" + Calendar.getInstance().getTimeInMillis()}));
            }
        }
        return this.defaultDownloadFolderForDownload;
    }

    @Override
    public DefaultedModel<String> createUserAppFolderModel(final DefaultedModel<File> defaultedModel) {
        return new DefaultedModel<String>(){

            public String getDefault() {
                return ((File)defaultedModel.getDefault()).getPath();
            }

            public String get() {
                return ((File)defaultedModel.get()).getPath();
            }

            public void set(String string) {
                defaultedModel.set((Object)new File(string));
            }
        };
    }

    @Override
    public Model<String> createActivationKeyModel() {
        return new ModelImpl((Object)this.properties.getProperty(InstallWizardPropertyKey.ACTIVATION_KEY.get(), ""));
    }

    @Override
    public Model<Boolean> createHasFikSwitch() {
        return new ModelImpl((Object)(this.properties.getProperty(InstallWizardPropertyKey.FILE_INSTALLATION_KEY.get()) != null ? 1 : 0));
    }

    @Override
    public Model<Boolean> createAgreeToLicenseSwitch() {
        return new ModelImpl((Object)this.properties.getProperty(InstallWizardPropertyKey.LICENSE.get(), "no").equalsIgnoreCase("yes"));
    }

    @Override
    public InstallOptionModel createDesktopOptionModel(InstallOption installOption) {
        InstallOptionModelImpl installOptionModelImpl = new InstallOptionModelImpl(installOption);
        installOptionModelImpl.setSelected(Boolean.valueOf(this.properties.getProperty(InstallWizardPropertyKey.DESKTOP_SHORTCUT.get(), Boolean.toString(installOptionModelImpl.isSelected()))));
        return installOptionModelImpl;
    }

    @Override
    public InstallOptionModel createStartMenuOptionModel(InstallOption installOption) {
        InstallOptionModelImpl installOptionModelImpl = new InstallOptionModelImpl(installOption);
        installOptionModelImpl.setSelected(Boolean.valueOf(this.properties.getProperty(InstallWizardPropertyKey.START_MENU_SHORTCUT.get(), Boolean.toString(installOptionModelImpl.isSelected()))));
        return installOptionModelImpl;
    }

    @Override
    public InstallOptionModel createLicenseServiceModel(InstallOption installOption) {
        InstallOptionModelImpl installOptionModelImpl = new InstallOptionModelImpl(installOption);
        installOptionModelImpl.setSelected(Boolean.valueOf(this.properties.getProperty(InstallWizardPropertyKey.LMGR_SERVICE.get(), Boolean.toString(installOptionModelImpl.isSelected()))));
        return installOptionModelImpl;
    }

    @Override
    public InstallOptionModel createSymbolicLinkOptionModel(InstallOption installOption) {
        InstallOptionModelImpl installOptionModelImpl = new InstallOptionModelImpl(installOption);
        if (Boolean.valueOf(this.properties.getProperty("bat", "false")).booleanValue()) {
            installOptionModelImpl.setSelected(false);
        }
        return installOptionModelImpl;
    }

    @Override
    public InstallOptionModel[] createDeletePreferencesOptionModels(InstallOption ... installOptionArray) {
        ArrayList<InstallOptionModelImpl> arrayList = new ArrayList<InstallOptionModelImpl>();
        for (InstallOption installOption : installOptionArray) {
            if (!InstallOptionType.DELETE_PREFERENCES.equals((Object)installOption.getType())) continue;
            InstallOptionModelImpl installOptionModelImpl = new InstallOptionModelImpl(installOption);
            installOptionModelImpl.setSelected(Boolean.valueOf(this.properties.getProperty(InstallWizardPropertyKey.PREFS.get(), Boolean.toString(installOptionModelImpl.isSelected()))));
            arrayList.add(installOptionModelImpl);
        }
        return arrayList.toArray(new InstallOptionModel[arrayList.size()]);
    }

    @Override
    public InstallOption[] getUninstallOptions(AvailableProduct[] availableProductArray, InstallOption ... installOptionArray) {
        return this.installConfiguration.getUninstallOptions(this.platform.getArchString(), (Product[])availableProductArray, installOptionArray);
    }

    @Override
    public Model<CheckBoxConfiguration> createOpenCheckBoxConfigurationModel() {
        if (this.platform.isLinux()) {
            return InstallModelFactoryImpl.createConfiguration(CheckBoxConfiguration.NOT_VISIBLE);
        }
        return InstallModelFactoryImpl.createConfiguration(CheckBoxConfiguration.SELECTED);
    }

    @Override
    public Model<Boolean> createInstallSwitch() {
        if (this.properties.getProperty(PropertyKey.DOWNLOAD_ONLY.get(), "no").equalsIgnoreCase("no")) {
            return new ModelImpl((Object)true);
        }
        return new ModelImpl((Object)false);
    }

    @Override
    public FileSystem createUserAppFileSystem(Long l, DefaultedModel<String> defaultedModel) {
        return this.fileSystemFactory.createUserAppFileSystem(l, defaultedModel);
    }

    @Override
    public Model<Boolean> createMCRInstallStatusModel(InstallWizardContext installWizardContext, Registry registry, Installer installer) {
        return new ModelImpl((Object)(!installWizardContext.getInstallConfiguration().canChangeFolder(this.platform, registry, installer) ? 1 : 0));
    }

    @Override
    public PlatformModel<AvailablePlatform> createPlatformModel() {
        PlatformModelImpl platformModelImpl = new PlatformModelImpl();
        Collection collection = platformModelImpl.getOrderedListOfAvailablePlatforms();
        NormalizedProperties normalizedProperties = new NormalizedProperties();
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(PLATFORM_PROPERTY_PREFIX, 0)) continue;
            normalizedProperties.setProperty(string, "");
        }
        boolean bl = false;
        if (!normalizedProperties.isEmpty()) {
            bl = true;
            for (AvailablePlatform availablePlatform : collection) {
                Object object = this.getPlatformName(availablePlatform);
                if (!normalizedProperties.containsKey(object)) continue;
                normalizedProperties.remove(object);
            }
        }
        boolean bl2 = false;
        if (bl && !normalizedProperties.isEmpty()) {
            bl2 = true;
        }
        for (Object object : collection) {
            if (bl2) {
                object.setSelected(false);
                continue;
            }
            if (bl) {
                if (this.properties.getProperty(this.getPlatformName((AvailablePlatform)object)) == null) continue;
                object.setSelected(true);
                continue;
            }
            if (!object.getName().equals(new PlatformImpl().getArchString())) continue;
            object.setSelected(true);
        }
        return platformModelImpl;
    }

    @Override
    public Model<Boolean> createEnableDLSwitchModel(String string) {
        return new ModelImpl((Object)(!new File(string + File.separator + ".disabledl").isFile() ? 1 : 0));
    }

    @Override
    public Model<Boolean> createEnableDLForWebOnlySwitchModel(String string) {
        return new ModelImpl((Object)(!new File(this.properties.getProperty("batDVD1Root", this.properties.getProperty("root")), ".dvd1").isFile() && !new File(string, ".dlarea").isFile() ? 1 : 0));
    }

    private String getPlatformName(AvailablePlatform availablePlatform) {
        return PLATFORM_PROPERTY_PREFIX + availablePlatform.getName();
    }

    @Override
    public Model<Boolean> createCustomSwitch() {
        return new ModelImpl((Object)(!this.isInteractive() && this.installConfiguration.canChooseTypicalOrCustom() ? 1 : 0));
    }

    @Override
    public Model<ConnectionMode> createConnectionModeModel() {
        String string = this.properties.getProperty(PropertyKey.CONNECTION_MODE.get());
        for (ConnectionMode connectionMode : ConnectionMode.values()) {
            if (!connectionMode.toString().equalsIgnoreCase(string)) continue;
            return new ModelImpl((Object)connectionMode);
        }
        return new ModelImpl((Object)(this.isInteractive() ? ConnectionMode.ONLINE : ConnectionMode.OFFLINE));
    }

    @Override
    public Model<CheckBoxConfiguration> createActivateCheckBoxConfigurationModel(ValidatedFik validatedFik, Installer installer, Model<Boolean> model, Model<String> model2) {
        CheckBoxConfiguration checkBoxConfiguration = this.canActivate(validatedFik, installer) && (Boolean)model.get() == false && this.isJITEntitlement(model2) ? this.createActivatableCheckBoxConfiguration() : CheckBoxConfiguration.NOT_VISIBLE;
        return InstallModelFactoryImpl.createConfiguration(checkBoxConfiguration);
    }

    private CheckBoxConfiguration createActivatableCheckBoxConfiguration() {
        if (this.isInteractive() || this.propertyDefined(PropertyKey.ACTIVATION_PROPERTIES_FILE)) {
            return CheckBoxConfiguration.SELECTED;
        }
        return CheckBoxConfiguration.VISIBLE_NOT_SELECTED;
    }

    private boolean propertyDefined(PropertyKey propertyKey) {
        return !"".equals(this.properties.getProperty(propertyKey.get(), ""));
    }

    private boolean canActivate(ValidatedFik validatedFik, Installer installer) {
        return validatedFik.canActivate() && installer.canActivate(this.installConfiguration);
    }

    private boolean isJITEntitlement(Model<String> model) {
        return ((String)model.get()).isEmpty();
    }

    private static ModelImpl<CheckBoxConfiguration> createConfiguration(CheckBoxConfiguration checkBoxConfiguration) {
        return new ModelImpl((Object)checkBoxConfiguration);
    }

    @Override
    public Model<CheckBoxConfiguration> createDeleteCheckBoxConfigurationModel(long l) {
        if (l > 0L) {
            return InstallModelFactoryImpl.createConfiguration(CheckBoxConfiguration.VISIBLE_NOT_SELECTED);
        }
        return InstallModelFactoryImpl.createConfiguration(CheckBoxConfiguration.NOT_VISIBLE);
    }

    private boolean isInteractive() {
        return this.properties.getProperty(PropertyKey.MODE.get(), "interactive").equalsIgnoreCase("interactive");
    }

    @Override
    public BackgroundTask createInstallTask(Installer installer, File file, File file2) {
        return this.taskFactory.createInstallTask(installer, file, file2);
    }

    @Override
    public BackgroundTask createDownloadTask(SoftwareManager softwareManager, File file) {
        return this.taskFactory.createDownloadTask(softwareManager, file);
    }

    @Override
    public BackgroundTask createUninstallTask(Installer installer, File file) {
        return this.taskFactory.createUninstallTask(installer, file);
    }

    @Override
    public DefaultedModel<String> createInstallFolderModel(Product[] productArray) {
        return this.folderModelFactory.createInstallFolderModel(productArray);
    }

    @Override
    public AccessibleTableFormat<MWAEntitlement> createEntitlementTableFormat() {
        return new EntitlementTableFormatImpl();
    }

    @Override
    public InstallWizardProperties createProperties(Properties properties) {
        return new InstallWizardPropertiesImpl(properties);
    }

    @Override
    public InstallWizardProperties createProperties() {
        return new InstallWizardPropertiesImpl();
    }

    @Override
    public Model<String> createLicenseFileModel() {
        return new ModelImpl((Object)this.properties.getProperty(PropertyKey.LICENSE_FILE_PATH.get(), ""));
    }

    @Override
    public InstallWizardContext createContext() {
        return new OfflineInstallWizardContext(this.installConfiguration, this.hyperlinkProvider, this.platform.getArchString());
    }

    @Override
    public InstallWizardContext createContext(String string) {
        return new OnlineInstallWizardContext(this.installConfiguration, this.hyperlinkProvider, string, this.platform.getArchString());
    }

    @Override
    public DefaultedModel<String> createDisplayedFolderModel(DefaultedModel<String> defaultedModel, Product[] productArray) {
        DefaultedModel<String> defaultedModel2 = this.folderModelFactory.createDisplayedFolderModel(defaultedModel, productArray);
        defaultedModel2.set((Object)this.properties.getProperty(InstallWizardPropertyKey.DESTINATION.get(), (String)defaultedModel2.get()));
        return defaultedModel2;
    }
}

