/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.model.AbstractTask;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.io.IOException;

final class DownloadTask
extends AbstractTask {
    private final SoftwareManager softwareManager;
    private final File downloadFolder;

    DownloadTask(SoftwareManager softwareManager, File file, WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, InstallStatusObserver ... installStatusObserverArray) {
        super(wizardUI, exceptionHandler, appLogger, installStatusObserverArray);
        this.softwareManager = softwareManager;
        this.downloadFolder = file;
    }

    @Override
    public ResourceKeys getErrorTitleResourceKey() {
        return ResourceKeys.INSTALLALERT_TITLE;
    }

    protected long calculateTotalUnits() {
        return this.softwareManager.getBytesRequired(this.downloadFolder);
    }

    protected void execute(InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray) throws IOException, InterruptedException {
        this.softwareManager.download(this.downloadFolder, installFlowControlHandler, installStatusObserverArray);
    }

    public String getAccessibleName() {
        return ResourceKeys.STATUS_ACCESSIBLE.getString(new Object[0]);
    }
}

