/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.SoftwareManager;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.ProductModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;

final class AvailableProductModel
implements ProductModel<AvailableProduct> {
    private final SoftwareManager softwareManager;
    private final Collection<WizardObserver> observers = new ArrayList<WizardObserver>();

    AvailableProductModel(SoftwareManager softwareManager) {
        this.softwareManager = softwareManager;
    }

    public Collection<AvailableProduct> getAvailable() {
        return Arrays.asList(this.softwareManager.getAvailableProducts());
    }

    public void toggleSelectAll() {
        if (this.allLatestSelected()) {
            this.unselectAll();
        } else {
            this.setAllLatestSelected();
        }
        this.notifyObservers();
    }

    public void toggleSelect(AvailableProduct availableProduct) {
        this.setSelected(availableProduct, !availableProduct.isSelected());
        this.notifyObservers();
    }

    public boolean isAnyControllingProductSelected() {
        return this.softwareManager.isAnyControllingProductSelected();
    }

    public boolean isAnyDownloadableProductAvailable() {
        for (AvailableProduct availableProduct : this.softwareManager.getAvailableProducts()) {
            if (availableProduct.getDownloadSize() <= 0L) continue;
            return true;
        }
        return false;
    }

    public void setSelected(AvailableProduct availableProduct, boolean bl) {
        if (!bl) {
            availableProduct.setSelected(false);
        } else {
            for (AvailableProduct availableProduct2 : this.softwareManager.getAvailableProducts()) {
                if (availableProduct2.getProductNumber() != availableProduct.getProductNumber()) continue;
                availableProduct2.setSelected(availableProduct2.equals(availableProduct));
            }
        }
        this.notifyObservers();
    }

    private AvailableProduct[] getLatestLocalAvailableProducts() {
        return AvailableProductModel.getLatestProducts(this.getLocalAvailableProducts());
    }

    private void notifyObservers() {
        for (WizardObserver wizardObserver : this.observers) {
            wizardObserver.update();
        }
    }

    public void addObserver(WizardObserver wizardObserver) {
        this.observers.add(wizardObserver);
    }

    public boolean multipleProductVersionsAvailable() {
        return this.getLatestAvailableProducts().length != this.getAvailable().size();
    }

    public boolean isAnyLocalProductAvailable() {
        return this.getLocalAvailableProducts().length > 0;
    }

    public boolean isAnyProductPreviouslyDownloaded() {
        Collection<AvailableProduct> collection = this.getAvailable();
        for (AvailableProduct availableProduct : collection) {
            if (availableProduct.getDownloadSize() != 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyProductInstalled() {
        Collection<AvailableProduct> collection = this.getAvailable();
        for (AvailableProduct availableProduct : collection) {
            if (!availableProduct.isInstalled()) continue;
            return true;
        }
        return false;
    }

    private AvailableProduct[] getLocalAvailableProducts() {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        for (AvailableProduct availableProduct : this.softwareManager.getAvailableProducts()) {
            if (availableProduct.getDownloadSize() != 0L) continue;
            arrayList.add(availableProduct);
        }
        return arrayList.toArray(new AvailableProduct[arrayList.size()]);
    }

    public boolean anySelected() {
        for (AvailableProduct availableProduct : this.softwareManager.getAvailableProducts()) {
            if (!availableProduct.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean allLatestSelected() {
        for (AvailableProduct availableProduct : this.getLatestAvailableProducts()) {
            if (availableProduct.isSelected() || !this.isSelectionAllowed(availableProduct)) continue;
            return false;
        }
        return true;
    }

    private void setAllLatestSelected() {
        this.unselectAll();
        for (AvailableProduct availableProduct : this.getLatestAvailableProducts()) {
            availableProduct.setSelected(this.isSelectionAllowed(availableProduct));
        }
    }

    private boolean isSelectionAllowed(AvailableProduct availableProduct) {
        return availableProduct.getDownloadSize() != 0L || this.softwareManager.canSelectIfAlreadyDownloaded();
    }

    private AvailableProduct[] getLatestAvailableProducts() {
        return AvailableProductModel.getLatestProducts(this.softwareManager.getAvailableProducts());
    }

    private static AvailableProduct[] getLatestProducts(AvailableProduct[] availableProductArray) {
        LinkedHashMap<Integer, AvailableProduct> linkedHashMap = new LinkedHashMap<Integer, AvailableProduct>();
        for (AvailableProduct availableProduct : availableProductArray) {
            if (linkedHashMap.containsKey(availableProduct.getProductNumber())) continue;
            linkedHashMap.put(availableProduct.getProductNumber(), availableProduct);
        }
        return linkedHashMap.values().toArray(new AvailableProduct[linkedHashMap.size()]);
    }

    private void unselectAll() {
        for (AvailableProduct availableProduct : this.softwareManager.getAvailableProducts()) {
            availableProduct.setSelected(false);
        }
    }
}

