/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_task.AbstractInstallTask;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.WizardUI;

abstract class AbstractTask
extends AbstractInstallTask {
    private final WizardUI wizardUI;
    private boolean retryResponse;
    private Throwable throwableException;

    AbstractTask(WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, InstallStatusObserver ... installStatusObserverArray) {
        super(exceptionHandler, appLogger, installStatusObserverArray);
        this.wizardUI = wizardUI;
    }

    public abstract ResourceKeys getErrorTitleResourceKey();

    public boolean shouldRetry(String string, String string2, Throwable throwable) {
        this.idle();
        this.throwableException = throwable;
        this.exHandler.logException(throwable);
        this.retryResponse = this.wizardUI.getResponseToYesNoQuestion(string, string2, MessageType.ERROR);
        this.active();
        return this.retryResponse;
    }

    public void alert(String string) {
        this.alert(this.getErrorTitleResourceKey().getString(new Object[0]), string);
    }

    public void alert(Exception exception) {
        String string = exception.getMessage();
        if (string != null && !string.equalsIgnoreCase("")) {
            this.alert(this.getErrorTitleResourceKey().getString(new Object[0]), string);
        } else {
            this.exHandler.logException((Throwable)exception);
            this.alert(this.getErrorTitleResourceKey().getString(new Object[0]), exception.getClass().toString());
        }
    }

    public void exception(Throwable throwable) {
        this.idle();
        if (!this.retryResponse && !throwable.equals(this.throwableException)) {
            this.exHandler.handleException(throwable, this.getErrorTitleResourceKey().getString(new Object[0]), throwable.getMessage());
        }
        this.active();
    }

    public void alert(String string, String string2) {
        this.idle();
        this.wizardUI.showErrorMessage(string, string2);
        this.active();
    }

    public void showInfoMessage(String string, String string2) throws InterruptedException {
        this.idle();
        this.wizardUI.showInfoMessage(string, string2);
        this.checkTaskState();
        this.active();
    }
}

