/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install_core_common.util.VerifyNetworkLicenseFileUtility;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.WizardUI;
import java.io.IOException;

class ValidateLicenseFileStep
extends AbstractCommandStep {
    private final Model<String> licenseFilePathModel;
    private final Model<String> licenseFileContentsModel;
    private final ExceptionHandler exceptionHandler;
    private final WizardUI wizardUI;
    private final AppLogger logger;
    private final Machine machineInfo;
    private static final String NO_HOSTID = "YOUR_HOSTID";
    private static final String MULTIPLE_HOSTIDS = "MULTIPLE_HOSTIDS";

    ValidateLicenseFileStep(Model<String> model, Model<String> model2, ExceptionHandler exceptionHandler, WizardUI wizardUI, AppLogger appLogger, Machine machine) {
        this.licenseFilePathModel = model;
        this.licenseFileContentsModel = model2;
        this.exceptionHandler = exceptionHandler;
        this.wizardUI = wizardUI;
        this.logger = appLogger;
        this.machineInfo = machine;
    }

    @Override
    protected boolean forwardVisitStep() {
        String string = (String)this.licenseFilePathModel.get();
        if (string != null) {
            if (VerifyNetworkLicenseFileUtility.isDirectory((String)string)) {
                this.wizardUI.showErrorMessage(InstutilResourceKeys.ERROR_LICENSEFILE_TITLE.getString(new Object[0]), InstutilResourceKeys.ERROR_LICENSEFILE_FOLDER.getString(new Object[]{string}));
                return false;
            }
            try {
                this.licenseFileContentsModel.set((Object)VerifyNetworkLicenseFileUtility.getLicenseFileContent((String)string));
            }
            catch (IOException iOException) {
                this.wizardUI.showErrorMessage(InstutilResourceKeys.ERROR_LICENSEFILE_TITLE.getString(new Object[0]), InstutilResourceKeys.ERROR_LICENSEFILE_EXCEPTION.getString(new Object[]{iOException.getMessage()}));
                return false;
            }
            String string2 = (String)this.licenseFileContentsModel.get();
            if (!VerifyNetworkLicenseFileUtility.checkLicenseFileformat((String)string2, (AppLogger)this.logger, (ExceptionHandler)this.exceptionHandler)) {
                this.wizardUI.showErrorMessage(ResourceKeys.ERROR_TITLE_LICENSEFILE_FORMAT.getString(new Object[0]), ResourceKeys.ERROR_LICENSEFILE_FORMAT.getString(string));
                return false;
            }
            if (!VerifyNetworkLicenseFileUtility.hasServerLine((String)string2, (ExceptionHandler)this.exceptionHandler)) {
                String string3 = VerifyNetworkLicenseFileUtility.getHostidFromComment((String)string2);
                if (string3.equalsIgnoreCase(NO_HOSTID)) {
                    return this.wizardUI.showWarningMessage(ResourceKeys.ERROR_HOSTID_TITLE.getString(new Object[0]), ResourceKeys.WARNING_HOSTID_MISSING.getString(new Object[0]));
                }
                if (string3.equalsIgnoreCase(MULTIPLE_HOSTIDS)) {
                    return true;
                }
                if (!VerifyNetworkLicenseFileUtility.isHostIDMatch((String)string3, (Machine)this.machineInfo)) {
                    return this.wizardUI.showWarningMessage(ResourceKeys.ERROR_HOSTID_TITLE.getString(new Object[0]), ResourceKeys.ERROR_HOSTID.getString(this.machineInfo.getEthernetAddress(), string3));
                }
            }
        }
        return true;
    }
}

