/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.wizard.PropertyKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

final class LaunchDeactivationStep
extends AbstractCommandStep {
    private final Installer installer;
    private final Properties cmdLineProperties;
    private final String installationFolder;
    private final ExecutorService executorService;
    private final InstallConfiguration installConfiguration;
    private final String archString;

    LaunchDeactivationStep(Installer installer, Properties properties, String string, ExecutorService executorService, InstallConfiguration installConfiguration, String string2) {
        this.installer = installer;
        this.cmdLineProperties = properties;
        this.installationFolder = string;
        this.executorService = executorService;
        this.installConfiguration = installConfiguration;
        this.archString = string2;
    }

    @Override
    protected boolean forwardVisitStep() {
        String string = this.cmdLineProperties.getProperty(PropertyKey.MODE.get(), "interactive");
        if (!string.equalsIgnoreCase("silent")) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-root");
            arrayList.add(this.installationFolder);
            arrayList.add("-prompt");
            String string3 = this.cmdLineProperties.getProperty(PropertyKey.AWS.get());
            if (string3 != null && !"".equalsIgnoreCase(string3)) {
                arrayList.add("-aws");
                arrayList.add(string3);
            }
            if ((string2 = this.cmdLineProperties.getProperty(PropertyKey.LWS.get())) != null && !"".equalsIgnoreCase(string2)) {
                arrayList.add("-lws");
                arrayList.add(string2);
            }
            this.launchDeactivationApplication(arrayList);
        }
        return true;
    }

    private void launchDeactivationApplication(final Collection<String> collection) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                LaunchDeactivationStep.this.installConfiguration.deactivateInstallation(LaunchDeactivationStep.this.archString, (Product[])LaunchDeactivationStep.this.installer.getSelectedAvailableProducts(), collection.toArray(new String[collection.size()]));
            }
        });
    }
}

