/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.webservices.dws.client.rest.DWSRestClient;
import com.mathworks.webservices.dws.client.rest.model.LanguageCodesForProfileResponse;
import com.mathworks.wizard.model.Model;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

final class GetLanguageCodesForProfileCallable
implements Callable<Boolean> {
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final DWSRestClient dwsRestClient;
    private final String securityToken;
    private final AppLogger logger;
    private Model<String[]> languagesModel;
    private final String archString;
    private String releaseString;

    GetLanguageCodesForProfileCallable(ExceptionHandler exceptionHandler, String string, DWSRestClient dWSRestClient, String string2, AppLogger appLogger, Model<String[]> model, String string3) {
        this.exceptionHandler = exceptionHandler;
        this.clientString = string;
        this.dwsRestClient = dWSRestClient;
        this.securityToken = string2;
        this.logger = appLogger;
        this.languagesModel = model;
        this.archString = string3;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    }

    @Override
    public Boolean call() throws Exception {
        try {
            LanguageCodesForProfileResponse languageCodesForProfileResponse = this.callService();
            this.apply(languageCodesForProfileResponse);
            return true;
        }
        catch (Exception exception) {
            this.exceptionHandler.handleException((Throwable)exception, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(this.releaseString, this.archString));
            return false;
        }
    }

    private LanguageCodesForProfileResponse callService() {
        LanguageCodesForProfileResponse languageCodesForProfileResponse = new LanguageCodesForProfileResponse();
        try {
            languageCodesForProfileResponse = this.dwsRestClient.getLanguageCodesForProfile(Locale.getDefault().toString(), this.clientString, this.securityToken);
        }
        catch (Throwable throwable) {
            this.logger.logMsg(throwable.getMessage());
        }
        return languageCodesForProfileResponse;
    }

    private void apply(LanguageCodesForProfileResponse languageCodesForProfileResponse) {
        List list = languageCodesForProfileResponse.getLanguageCode();
        if (list.isEmpty()) {
            this.languagesModel.set((Object)new String[0]);
        } else {
            this.languagesModel.set((Object)list.toArray(new String[list.size()]));
        }
    }
}

