/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.webservices.dws.client.rest.DWSRestClient;
import com.mathworks.webservices.dws.client.rest.model.Installer;
import com.mathworks.webservices.dws.client.rest.model.InstallerDataRequest;
import com.mathworks.webservices.dws.client.rest.model.InstallerDataResponse;
import com.mathworks.webservices.dws.client.rest.model.InstallerNames;
import com.mathworks.wizard.model.Model;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

final class GetInstallerInDownloadOnlyCallable
implements Callable<Boolean> {
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final Model<String[]> installerNames;
    private final DWSRestClient dwsRestClient;
    private final Model<String> securityToken;
    private final Model<InstallerDownloadURLInfo[]> urlDataModel;
    private final AppLogger logger;
    private final String archString;
    private String releaseString;

    GetInstallerInDownloadOnlyCallable(ExceptionHandler exceptionHandler, String string, DWSRestClient dWSRestClient, Model<String[]> model, Model<String> model2, Model<InstallerDownloadURLInfo[]> model3, AppLogger appLogger, String string2) {
        this.exceptionHandler = exceptionHandler;
        this.clientString = string;
        this.installerNames = model;
        this.dwsRestClient = dWSRestClient;
        this.securityToken = model2;
        this.urlDataModel = model3;
        this.logger = appLogger;
        this.archString = string2;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    }

    private InstallerDataResponse callService() {
        try {
            InstallerDataRequest installerDataRequest = new InstallerDataRequest();
            installerDataRequest.setRelease(this.releaseString);
            installerDataRequest.setTargetUpdateRelease(InstutilResourceKeys.RELEASE_DESCRIPTION.getString(new Object[0]));
            InstallerNames installerNames = new InstallerNames();
            installerNames.getName().addAll(Arrays.asList((Object[])this.installerNames.get()));
            installerDataRequest.setInstallerNames(installerNames);
            return this.dwsRestClient.getInstallers(Locale.getDefault().toString(), this.clientString, (String)this.securityToken.get(), installerDataRequest);
        }
        catch (Throwable throwable) {
            this.logger.logMsg(throwable.getMessage());
            return new InstallerDataResponse();
        }
    }

    private void apply(InstallerDataResponse installerDataResponse) {
        try {
            boolean bl;
            List list = installerDataResponse.getInstaller();
            String string = System.getenv(ResourceKeys.MW_ARCHIVE_LOCATION.getString(new Object[0]));
            String string2 = System.getenv(ResourceKeys.MW_INSTALLER_LOCATION.getString(new Object[0]));
            boolean bl2 = string != null && !string.isEmpty();
            boolean bl3 = bl = string2 != null && !string2.isEmpty();
            if (list.size() <= 0) {
                this.logger.logMsg("No URLs returned");
            } else if (((String[])this.installerNames.get()).length != list.size()) {
                this.logger.logMsg("No. of urls do not match the number of architectures");
                this.logger.logMsg("Installer names length: " + ((String[])this.installerNames.get()).length + " Response Installer length: " + list.size());
            } else {
                if (bl2 && !bl) {
                    return;
                }
                ArrayList<InstallerDownloadURLInfo> arrayList = new ArrayList<InstallerDownloadURLInfo>();
                for (Installer installer : list) {
                    URL uRL = new URL(installer.getUrl());
                    if (bl2 && bl) {
                        uRL = new File(string2 + File.separator + installer.getName()).toURI().toURL();
                    }
                    arrayList.add(new InstallerDownloadURLInfo(installer.getName(), uRL));
                }
                this.urlDataModel.set((Object)arrayList.toArray(new InstallerDownloadURLInfo[arrayList.size()]));
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.logger.logMsg(malformedURLException.getMessage());
        }
    }

    @Override
    public Boolean call() throws Exception {
        try {
            InstallerDataResponse installerDataResponse = this.callService();
            this.apply(installerDataResponse);
            return true;
        }
        catch (Exception exception) {
            this.exceptionHandler.handleException((Throwable)exception, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(this.releaseString, this.archString));
            return false;
        }
    }
}

