/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.Installer;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;

final class CheckProductFamilyAndVersionStep
extends AbstractCommandStep {
    private final Model<Installer> installerModel;
    private final DefaultedModel<String> folder;
    private final WizardUI ui;

    CheckProductFamilyAndVersionStep(Model<Installer> model, DefaultedModel<String> defaultedModel, WizardUI wizardUI) {
        this.installerModel = model;
        this.folder = defaultedModel;
        this.ui = wizardUI;
    }

    @Override
    void reverseVisitStep() {
    }

    @Override
    protected boolean forwardVisitStep() {
        File file = new File((String)this.folder.get());
        AvailableProduct[] availableProductArray = ((Installer)this.installerModel.get()).getSelectedProductsAlreadyInstalled(file);
        AvailableProduct[] availableProductArray2 = ((Installer)this.installerModel.get()).getIncompatibleProducts(file);
        if (availableProductArray2.length > 0) {
            return this.getResponseToIncompatibleProductsQuestion(availableProductArray2[0]);
        }
        Response response = Response.YES;
        for (AvailableProduct availableProduct : availableProductArray) {
            Response response2 = this.getResponseToVersionQuestion(file, availableProduct, response);
            if (!Response.CANCEL.equals((Object)response2)) continue;
            response = response2;
        }
        return !Response.CANCEL.equals((Object)response);
    }

    private Response getResponseToVersionQuestion(File file, AvailableProduct availableProduct, Response response) {
        if (this.shouldDisplayVersionQuestion(file, availableProduct, response)) {
            return this.getResponseToVersionQuestion(availableProduct);
        }
        return response;
    }

    private boolean shouldDisplayVersionQuestion(File file, AvailableProduct availableProduct, Response response) {
        return (Response.YES.equals((Object)response) || Response.YES_TO_ALL.equals((Object)response)) && ((Installer)this.installerModel.get()).folderContainsNewerVersion(availableProduct, file);
    }

    private Response getResponseToVersionQuestion(AvailableProduct availableProduct) {
        return this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE_WARNING.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_VERSION.getString(availableProduct.getName()), MessageType.WARNING, OptionType.YES_NO_CANCEL);
    }

    private boolean getResponseToIncompatibleProductsQuestion(AvailableProduct availableProduct) {
        Response response = this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE_WARNING.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_INCOMPATIBLE.getString(availableProduct.getName()), MessageType.QUESTION, OptionType.OK_CANCEL);
        return !response.equals((Object)Response.CANCEL);
    }
}

