/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.Installer;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.util.ArrayList;

final class CheckOverwritesStep
extends AbstractCommandStep {
    private final Installer install;
    private final DefaultedModel<String> folder;
    private final WizardUI ui;

    CheckOverwritesStep(Installer installer, DefaultedModel<String> defaultedModel, WizardUI wizardUI) {
        this.install = installer;
        this.folder = defaultedModel;
        this.ui = wizardUI;
    }

    @Override
    void reverseVisitStep() {
        this.resetAvailableProducts();
    }

    @Override
    protected boolean forwardVisitStep() {
        this.resetAvailableProducts();
        File file = new File((String)this.folder.get());
        AvailableProduct[] availableProductArray = this.install.getSelectedProductsAlreadyInstalled(file);
        AvailableProduct[] availableProductArray2 = this.install.getIncompatibleProducts(file);
        if (availableProductArray2.length > 0) {
            return this.getResponseToIncompatibleProductsQuestion(availableProductArray2[0]);
        }
        Response response = this.processProductsToOverwrite(file, availableProductArray);
        if (Response.CANCEL.equals((Object)response)) {
            return false;
        }
        boolean bl = false;
        for (AvailableProduct availableProduct : this.install.getAvailableProducts()) {
            if (!availableProduct.canInstall()) continue;
            bl = true;
        }
        if (!bl) {
            this.ui.showErrorMessage(ResourceKeys.OVERWRITE_TITLE_NOPRODUCTS.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_NOPRODUCTS.getString(new Object[0]));
            return false;
        }
        return true;
    }

    private Response processProductsToOverwrite(File file, AvailableProduct[] availableProductArray) {
        String string = CheckOverwritesStep.getProductListForOverwriteQuestion(availableProductArray);
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        Response response = Response.YES;
        for (AvailableProduct availableProduct : availableProductArray) {
            Response response2 = this.getResponseToVersionQuestion(file, availableProduct, response = this.getResponseToOverwriteQuestion(string, response, availableProduct));
            if (Response.CANCEL.equals((Object)response2)) {
                response = response2;
                continue;
            }
            if (!Response.NO.equals((Object)response2) && !Response.NO_TO_ALL.equals((Object)response2)) continue;
            arrayList.add(availableProduct);
        }
        for (AvailableProduct availableProduct : arrayList) {
            availableProduct.setOverwrite(false);
        }
        return response;
    }

    private Response getResponseToVersionQuestion(File file, AvailableProduct availableProduct, Response response) {
        if (this.shouldDisplayVersionQuestion(file, availableProduct, response)) {
            return this.getResponseToVersionQuestion(availableProduct);
        }
        return response;
    }

    private boolean shouldDisplayVersionQuestion(File file, AvailableProduct availableProduct, Response response) {
        return (Response.YES.equals((Object)response) || Response.YES_TO_ALL.equals((Object)response)) && this.install.folderContainsNewerVersion(availableProduct, file);
    }

    private Response getResponseToVersionQuestion(AvailableProduct availableProduct) {
        return this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE_WARNING.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_VERSION.getString(availableProduct.getName()), MessageType.WARNING, OptionType.YES_NO_CANCEL);
    }

    private Response getResponseToOverwriteQuestion(String string, Response response, AvailableProduct availableProduct) {
        if (Response.NO_TO_ALL.equals((Object)response) || Response.YES_TO_ALL.equals((Object)response) || Response.CANCEL.equals((Object)response)) {
            return response;
        }
        return this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE.getString(string, availableProduct.getName()), MessageType.QUESTION, OptionType.YESTOALL_NOTOALL);
    }

    private boolean getResponseToIncompatibleProductsQuestion(AvailableProduct availableProduct) {
        Response response = this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE_WARNING.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_INCOMPATIBLE.getString(availableProduct.getName()), MessageType.QUESTION, OptionType.OK_CANCEL);
        return !response.equals((Object)Response.CANCEL);
    }

    private void resetAvailableProducts() {
        for (AvailableProduct availableProduct : this.install.getAvailableProducts()) {
            availableProduct.setOverwrite(true);
        }
    }

    private static String getProductListForOverwriteQuestion(AvailableProduct[] availableProductArray) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (AvailableProduct availableProduct : availableProductArray) {
            if (n == 0) {
                stringBuilder.append(availableProduct.getName());
            } else {
                if (n >= 5) {
                    stringBuilder.append(ResourceKeys.OVER_PRODUCT_LIMIT.getString(new Object[0]));
                    break;
                }
                stringBuilder.append(ResourceKeys.ANOTHER_PRODUCT.getString(availableProduct.getName()));
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

