/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.util.regex.Pattern;

public class CheckInvalidInstallationDirectoryStep
extends AbstractCommandStep {
    private final DefaultedModel<String> displayedFolder;
    private final WizardUI wizardUI;
    private final ExceptionHandler exceptionHandler;

    CheckInvalidInstallationDirectoryStep(DefaultedModel<String> defaultedModel, WizardUI wizardUI, ExceptionHandler exceptionHandler) {
        this.displayedFolder = defaultedModel;
        this.wizardUI = wizardUI;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    protected boolean forwardVisitStep() {
        try {
            String string = this.getApplicationDirectoryInstallPath().concat(File.separator);
            String string2 = (String)this.displayedFolder.get();
            if (Pattern.matches("^[A-Za-z]:\\\\$", string2) || string.trim().equalsIgnoreCase(string2.trim())) {
                String string3 = string2.concat(ResourceKeys.MATLAB_STRING.getString(new Object[0]).concat(File.separator).concat(InstutilResourceKeys.RELEASE.getString(new Object[0])).concat(File.separator));
                Response response = this.wizardUI.getResponseToQuestion(ResourceKeys.INSTALL_FOLDER.getString(new Object[0]), ResourceKeys.INVALID_INSTALLATION_DIRECTORY.getString(string2, string3), MessageType.QUESTION, OptionType.DEFAULT_RECOMMEND_ACCEPT_RECOMMEND_CANCEL);
                if (response.equals((Object)Response.YES)) {
                    this.displayedFolder.set((Object)string3);
                } else if (response.equals((Object)Response.CANCEL)) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            this.exceptionHandler.handleException((Throwable)exception);
            return false;
        }
        return true;
    }

    private native String getApplicationDirectoryInstallPath();
}

