/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.Installer;
import com.mathworks.install.InvalidInstallationFolderException;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;

final class CheckIfOverwriteImpossibleStep
extends AbstractCommandStep {
    private final Model<Installer> installerModel;
    private final DefaultedModel<String> folderModel;
    private final WizardUI wizardUI;

    CheckIfOverwriteImpossibleStep(Model<Installer> model, DefaultedModel<String> defaultedModel, WizardUI wizardUI) {
        this.installerModel = model;
        this.folderModel = defaultedModel;
        this.wizardUI = wizardUI;
    }

    @Override
    protected boolean forwardVisitStep() {
        try {
            ((Installer)this.installerModel.get()).checkIfOverwritePossible(this.getFolder());
            return true;
        }
        catch (InvalidInstallationFolderException invalidInstallationFolderException) {
            this.showMessage(invalidInstallationFolderException.getMessage());
            return false;
        }
    }

    private void showMessage(String string) {
        this.wizardUI.showErrorMessage(ResourceKeys.INSTALL_ERROR_TITLE.getString(new Object[0]), string);
    }

    private File getFolder() {
        return new File((String)this.folderModel.get());
    }
}

