/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.webservices.dws.client.rest.DWSRestClient;
import com.mathworks.webservices.dws.client.rest.model.Architectures;
import com.mathworks.webservices.dws.client.rest.model.EntitledProduct;
import com.mathworks.webservices.dws.client.rest.model.EntitledProducts;
import com.mathworks.webservices.dws.client.rest.model.ReleaseData;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataRequest;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataResponse;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDatas;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.PlatformModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

final class CheckForUpdatesInDownloadOnlyCallable
implements Callable<Boolean> {
    private static final String EMPTY_ENTITLEMENT_ID = "";
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final DWSRestClient dwsRestClient;
    private final Model<String> securityToken;
    private final Model<Boolean> checkForUpdatesSwitch;
    private final Model<ReleaseData[]> releaseDataModel;
    private final AppLogger logger;
    private Model<EntitledProduct[]> entitledProductsModel;
    private final PlatformModel<AvailablePlatform> platformModel;
    private final String archString;
    private String releaseString;

    CheckForUpdatesInDownloadOnlyCallable(ExceptionHandler exceptionHandler, String string, DWSRestClient dWSRestClient, Model<String> model, Model<Boolean> model2, Model<ReleaseData[]> model3, AppLogger appLogger, Model<EntitledProduct[]> model4, PlatformModel<AvailablePlatform> platformModel, String string2) {
        this.exceptionHandler = exceptionHandler;
        this.clientString = string;
        this.dwsRestClient = dWSRestClient;
        this.securityToken = model;
        this.checkForUpdatesSwitch = model2;
        this.releaseDataModel = model3;
        this.logger = appLogger;
        this.entitledProductsModel = model4;
        this.platformModel = platformModel;
        this.archString = string2;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    }

    @Override
    public Boolean call() throws Exception {
        try {
            ReleaseDataResponse releaseDataResponse = this.callService();
            this.apply(releaseDataResponse);
            return true;
        }
        catch (Exception exception) {
            this.exceptionHandler.handleException((Throwable)exception, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(this.releaseString, this.archString));
            return false;
        }
    }

    private ReleaseDataResponse callService() throws IOException {
        ReleaseDataResponse releaseDataResponse = new ReleaseDataResponse();
        try {
            Architectures architectures = new Architectures();
            for (String string : this.platformModel.getSelectedPlatforms()) {
                architectures.getArchitecture().add(string);
            }
            ReleaseDataRequest releaseDataRequest = new ReleaseDataRequest();
            releaseDataRequest.setEntitlementId(EMPTY_ENTITLEMENT_ID);
            releaseDataRequest.setRelease(this.releaseString);
            releaseDataRequest.setTargetUpdateRelease(InstutilResourceKeys.RELEASE_DESCRIPTION.getString(new Object[0]));
            releaseDataRequest.setArchitectures(architectures);
            releaseDataResponse = this.dwsRestClient.getReleaseData(Locale.getDefault().toString(), this.clientString, (String)this.securityToken.get(), releaseDataRequest);
        }
        catch (Throwable throwable) {
            ReleaseDatas releaseDatas = new ReleaseDatas();
            releaseDatas.getReleaseData().addAll(new ArrayList());
            releaseDataResponse.setReleaseDatas(releaseDatas);
            EntitledProducts entitledProducts = new EntitledProducts();
            entitledProducts.getEntitledProduct().addAll(new ArrayList());
            releaseDataResponse.setEntitledProducts(entitledProducts);
        }
        return releaseDataResponse;
    }

    private void apply(ReleaseDataResponse releaseDataResponse) {
        List list = releaseDataResponse.getReleaseDatas().getReleaseData();
        List list2 = releaseDataResponse.getEntitledProducts().getEntitledProduct();
        if (list2.isEmpty()) {
            this.logger.logMsg("Empty EntitledProduct array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else if (list.isEmpty()) {
            this.logger.logMsg("Empty ReleaseData array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else {
            this.releaseDataModel.set((Object)list.toArray((Object[])this.releaseDataModel.get()));
            this.entitledProductsModel.set((Object)list2.toArray((Object[])this.entitledProductsModel.get()));
            this.checkForUpdatesSwitch.set((Object)true);
        }
    }
}

