/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.command.AbstractNewWebserviceCallable;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.mlwebservices.webserviceproxy.DWSRestClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.dws.client.rest.model.Architectures;
import com.mathworks.webservices.dws.client.rest.model.EntitledProduct;
import com.mathworks.webservices.dws.client.rest.model.EntitledProducts;
import com.mathworks.webservices.dws.client.rest.model.ReleaseData;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataRequest;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataResponse;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDatas;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.WizardUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class CheckForUpdatesCallable
extends AbstractNewWebserviceCallable<ReleaseDataResponse> {
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final String arch;
    private final DWSRestClientProxy dwsRestClient;
    private final Model<String> securityToken;
    private final Model<MWAEntitlement> entitlement;
    private final Model<Boolean> checkForUpdatesSwitch;
    private final Model<Boolean> getUpdatesSwitch;
    private final Model<ReleaseData[]> releaseDataModel;
    private final Model<ValidatedFik> validatedFikModel;
    private final AppLogger logger;
    private final Model<String> targetReleaseModel;
    private String releaseString;

    CheckForUpdatesCallable(WizardUI wizardUI, ExceptionHandler exceptionHandler, String string, DWSRestClientProxy dWSRestClientProxy, String string2, Model<String> model, Model<MWAEntitlement> model2, Model<Boolean> model3, Model<Boolean> model4, Model<ReleaseData[]> model5, Model<ValidatedFik> model6, AppLogger appLogger, Model<String> model7) {
        super((WebServiceClientProxy)dWSRestClientProxy, exceptionHandler, InstutilResourceKeys.RELEASE.getString(new Object[0]), string2, wizardUI);
        this.exceptionHandler = exceptionHandler;
        this.clientString = string;
        this.arch = string2;
        this.dwsRestClient = dWSRestClientProxy;
        this.securityToken = model;
        this.entitlement = model2;
        this.checkForUpdatesSwitch = model3;
        this.getUpdatesSwitch = model4;
        this.releaseDataModel = model5;
        this.validatedFikModel = model6;
        this.logger = appLogger;
        this.targetReleaseModel = model7;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    }

    @Override
    protected ReleaseDataResponse callService() {
        ReleaseDataResponse releaseDataResponse = new ReleaseDataResponse();
        try {
            Architectures architectures = new Architectures();
            architectures.getArchitecture().add(this.arch);
            ReleaseDataRequest releaseDataRequest = new ReleaseDataRequest();
            releaseDataRequest.setRelease(this.releaseString);
            releaseDataRequest.setArchitectures(architectures);
            releaseDataRequest.setTargetUpdateRelease((String)this.targetReleaseModel.get());
            releaseDataRequest.setEntitlementId(((MWAEntitlement)this.entitlement.get()).getId());
            releaseDataResponse = this.dwsRestClient.getReleaseData(Locale.getDefault().toString(), this.clientString, (String)this.securityToken.get(), releaseDataRequest);
        }
        catch (MathWorksServiceException mathWorksServiceException) {
            throw mathWorksServiceException;
        }
        catch (Throwable throwable) {
            ReleaseDatas releaseDatas = new ReleaseDatas();
            releaseDatas.getReleaseData().addAll(new ArrayList());
            releaseDataResponse.setReleaseDatas(releaseDatas);
            EntitledProducts entitledProducts = new EntitledProducts();
            entitledProducts.getEntitledProduct().addAll(new ArrayList());
            releaseDataResponse.setEntitledProducts(entitledProducts);
        }
        return releaseDataResponse;
    }

    @Override
    protected void processException(Exception exception) {
        if (exception instanceof MathWorksServiceException && Integer.parseInt(((MathWorksServiceException)((Object)exception)).getSeverity()) == 1) {
            this.showMessageBySeverity(exception.getMessage());
        } else {
            this.exceptionHandler.handleException((Throwable)exception, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(this.releaseString, this.arch));
        }
    }

    @Override
    protected void apply(ReleaseDataResponse releaseDataResponse) {
        List list = releaseDataResponse.getReleaseDatas().getReleaseData();
        List list2 = releaseDataResponse.getEntitledProducts().getEntitledProduct();
        if (list2.isEmpty()) {
            this.logger.logMsg("Empty EntitledProduct array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else if (list.isEmpty()) {
            this.logger.logMsg("Empty ReleaseData array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else {
            this.checkForUpdatesSwitch.set((Object)true);
            this.releaseDataModel.set((Object)list.toArray((Object[])this.releaseDataModel.get()));
            this.validatedFikModel.set((Object)new DWSEnabledValidatedFik((ValidatedFik)this.validatedFikModel.get(), list2.toArray(new EntitledProduct[list2.size()])));
        }
    }

    private class DWSEnabledValidatedFik
    implements ValidatedFik {
        private final ValidatedFik inner;
        private final EntitledProduct[] entitledProducts;

        DWSEnabledValidatedFik(ValidatedFik validatedFik, EntitledProduct[] entitledProductArray) {
            this.inner = validatedFik;
            this.entitledProducts = (EntitledProduct[])entitledProductArray.clone();
        }

        public String get() {
            return this.inner.get();
        }

        public boolean canActivate() {
            return this.inner.canActivate();
        }

        public boolean canInstall(Product product, long l) {
            if (this.inner.canInstall(product, l) && (((Boolean)CheckForUpdatesCallable.this.getUpdatesSwitch.get()).booleanValue() || l == 0L)) {
                if (l == 0L) {
                    return true;
                }
                for (EntitledProduct entitledProduct : this.entitledProducts) {
                    if (entitledProduct.getBitNumber() != product.getProductNumber() || VersionUtils.compareVersionNumbers((String)entitledProduct.getVersion(), (String)product.getVersion()) <= -1) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public boolean requiresLicenseFile() {
            return this.inner.requiresLicenseFile();
        }

        public boolean isJITEnabledFik() {
            return this.inner.isJITEnabledFik();
        }

        public boolean isTEUEnabledFik() {
            return this.inner.isTEUEnabledFik();
        }

        public Integer[] getProducts() {
            return this.inner.getProducts();
        }
    }
}

