/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.CorruptedArchivesException;
import com.mathworks.install.SoftwareManagerBuilder;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.util.concurrent.Callable;

class BuildSoftwareManagerCallable
implements Callable<Boolean> {
    private SoftwareManagerBuilder softwareManagerBuilder;
    private ExceptionHandler exceptionHandler;
    private WizardUI wizardUI;

    BuildSoftwareManagerCallable(SoftwareManagerBuilder softwareManagerBuilder, ExceptionHandler exceptionHandler, WizardUI wizardUI) {
        this.softwareManagerBuilder = softwareManagerBuilder;
        this.exceptionHandler = exceptionHandler;
        this.wizardUI = wizardUI;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            this.softwareManagerBuilder.finishReadingArchives();
        }
        catch (CorruptedArchivesException corruptedArchivesException) {
            StringBuilder stringBuilder = new StringBuilder(10);
            for (File file : corruptedArchivesException.getCorruptedArchives()) {
                this.exceptionHandler.logException(corruptedArchivesException.getExceptionForFile(file));
                stringBuilder.append("<br>").append(file.getAbsolutePath());
            }
            return this.wizardUI.showWarningMessage(ResourceKeys.EXTRACT_TITLE.getString(new Object[0]), ResourceKeys.EXTRACT_CORRUPTLIST.getString(stringBuilder.toString()));
        }
        return true;
    }
}

