/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.mlwebservices.webserviceproxy.WebServiceClientProxy;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.wizard.ui.WizardUI;
import java.util.concurrent.Callable;

abstract class AbstractNewWebserviceCallable<R>
implements Callable<Boolean> {
    private WebServiceClientProxy client;
    private ExceptionHandler exceptionHandler;
    private String releaseString;
    private String arch;
    private WizardUI wizardUI;
    private final String title;
    private final String message;

    protected AbstractNewWebserviceCallable(WebServiceClientProxy webServiceClientProxy, ExceptionHandler exceptionHandler, String string, String string2, WizardUI wizardUI) {
        this.client = webServiceClientProxy;
        this.exceptionHandler = exceptionHandler;
        this.releaseString = string;
        this.arch = string2;
        this.wizardUI = wizardUI;
        this.title = ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]);
        this.message = ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(string, string2);
    }

    protected AbstractNewWebserviceCallable(WebServiceClientProxy webServiceClientProxy, ExceptionHandler exceptionHandler, WizardUI wizardUI, String string, String string2) {
        this.client = webServiceClientProxy;
        this.exceptionHandler = exceptionHandler;
        this.wizardUI = wizardUI;
        this.title = string;
        this.message = string2;
    }

    @Override
    public Boolean call() throws Exception {
        try {
            this.client.configureProxies();
            R r = this.callService();
            this.apply(r);
            return true;
        }
        catch (MathWorksClientException mathWorksClientException) {
            this.processMathWorksClientException(mathWorksClientException);
            return false;
        }
        catch (Exception exception) {
            this.processException(exception);
            return false;
        }
    }

    protected void processMathWorksClientException(MathWorksClientException mathWorksClientException) {
        this.showError(mathWorksClientException.getErrorCode(), mathWorksClientException.getMessage());
    }

    protected void processException(Exception exception) {
        this.exceptionHandler.handleException((Throwable)exception, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(this.releaseString, this.arch));
    }

    protected void showMessageBySeverity(String string) {
        this.wizardUI.showErrorMessage(ResourceKeys.VERIFY_LOGIN_INFORMATION.getString(new Object[0]), string);
    }

    private void showError(Object ... objectArray) {
        this.wizardUI.showErrorMessage(ResourceKeys.ERROR_SERVICE_TITLE.getString(new Object[0]), ResourceKeys.ERROR.getString(objectArray));
    }

    protected abstract void apply(R var1);

    protected abstract R callService();
}

