/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.dws.client.rest.DWSRestClient;
import com.mathworks.webservices.dws.client.rest.model.Component;
import com.mathworks.webservices.dws.client.rest.model.ComponentDataRequest;
import com.mathworks.webservices.dws.client.rest.model.ComponentId;
import com.mathworks.webservices.dws.client.rest.model.ComponentIds;
import com.mathworks.webservices.dws.client.rest.model.ReleaseData;
import com.mathworks.wizard.model.Model;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;

abstract class AbstractGetUpdatesCallable
implements Callable<Boolean> {
    private final ExceptionHandler exceptionHandler;
    private final String clientString;
    private final Model<String> securityToken;
    private final DWSRestClient dwsRestClient;
    private final Model<ReleaseData[]> releaseDataModel;
    private final Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private final IO io;
    private final String archString;
    private final UsageDataCollector usageDataCollector;
    private final String releaseString;

    AbstractGetUpdatesCallable(ExceptionHandler exceptionHandler, String string, Model<String> model, DWSRestClient dWSRestClient, Model<ReleaseData[]> model2, Downloader downloader, ProxyConfiguration proxyConfiguration, IO iO, String string2, UsageDataCollector usageDataCollector) {
        this.exceptionHandler = exceptionHandler;
        this.clientString = string;
        this.securityToken = model;
        this.dwsRestClient = dWSRestClient;
        this.releaseDataModel = model2;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.io = iO;
        this.archString = string2;
        this.usageDataCollector = usageDataCollector;
        this.releaseString = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws IOException, InterruptedException {
        try {
            MyComponentURLProvider myComponentURLProvider = new MyComponentURLProvider(this.clientString, Locale.getDefault().toString());
            for (ReleaseData releaseData : (ReleaseData[])this.releaseDataModel.get()) {
                File file = null;
                try {
                    file = File.createTempFile("dwsZipFile", null);
                    URL uRL = new URL(releaseData.getUrl());
                    this.downloader.download(this.proxyConfiguration, uRL, file, new IOObserver[0]);
                    myComponentURLProvider.setReleaseId(releaseData.getReleaseId());
                    this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_TARGET_UPDATE_LEVEL, (Object)releaseData.getReleaseId());
                    this.addReleaseData(myComponentURLProvider, file);
                }
                finally {
                    this.io.deleteFile(file);
                }
            }
            myComponentURLProvider.doCall();
            return true;
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException(throwable, ResourceKeys.ERROR_CONNECTION_TITLE.getString(new Object[0]), ResourceKeys.ERROR_CONNECTION_MESSAGE.getString(this.releaseString, this.archString));
            return false;
        }
    }

    abstract void addReleaseData(MyComponentURLProvider var1, File var2);

    private String getComponentPath(Component component) {
        String string = component.getComponentId().getName();
        if (string.contains("_doc_ja")) {
            return "doc_ja";
        }
        if (string.contains("_doc_ko_KR")) {
            return "doc_ko";
        }
        if (string.contains("_doc_zh_CN")) {
            return "doc_zh";
        }
        if (string.contains("_common")) {
            return "common";
        }
        if (string.contains("_glnxa64")) {
            return "glnxa64";
        }
        if (string.contains("_maci64")) {
            return "maci64";
        }
        if (string.contains("_win32")) {
            return "win32";
        }
        if (string.contains("_win64")) {
            return "win64";
        }
        return "";
    }

    protected class MyComponentURLProvider
    implements ComponentURLProvider {
        private final String clientString;
        private final String localeString;
        private final Collection<ComponentId> componentIdsList = new ArrayList<ComponentId>();
        private final Map<String, String> componentIdToURLMap = new HashMap<String, String>();
        private String releaseId;

        MyComponentURLProvider(String string, String string2) {
            this.clientString = string;
            this.localeString = string2;
        }

        private void doCall() throws MathWorksClientException, MathWorksServiceException {
            ComponentIds componentIds;
            ComponentDataRequest componentDataRequest = new ComponentDataRequest();
            componentDataRequest.setRelease(AbstractGetUpdatesCallable.this.releaseString);
            if (!this.componentIdsList.isEmpty()) {
                componentIds = new ComponentIds();
                componentIds.getComponentId().addAll(this.componentIdsList);
                componentDataRequest.setComponentIds(componentIds);
            }
            componentIds = AbstractGetUpdatesCallable.this.dwsRestClient.getComponents(this.localeString, this.clientString, (String)AbstractGetUpdatesCallable.this.securityToken.get(), componentDataRequest);
            List list = componentIds.getComponent();
            String string = System.getenv(ResourceKeys.MW_ARCHIVE_LOCATION.getString(new Object[0]));
            boolean bl = string != null && !string.isEmpty();
            for (Component component : list) {
                File file;
                ComponentId componentId = component.getComponentId();
                String string2 = componentId.getName();
                String string3 = componentId.getVersion();
                String string4 = component.getComponentUrl();
                if (bl && !(file = new File(string + File.separator + AbstractGetUpdatesCallable.this.getComponentPath(component) + File.separator + this.getKey(string2, string3) + ".enc")).isFile()) {
                    try {
                        string4 = file.toURI().toURL().toString();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this.componentIdToURLMap.put(this.getKey(string2, string3), string4);
            }
        }

        public String getURL(String string, String string2) {
            return this.componentIdToURLMap.get(this.getKey(string, string2));
        }

        private String getKey(String string, String string2) {
            return string + "_" + string2;
        }

        public void add(String string, String string2) {
            ComponentId componentId = new ComponentId();
            componentId.setCurrentUpdateRelease(this.releaseId);
            ReleaseData[] releaseDataArray = (ReleaseData[])AbstractGetUpdatesCallable.this.releaseDataModel.get();
            String string3 = releaseDataArray[0].getReleaseId();
            componentId.setTargetUpdateRelease(string3);
            componentId.setName(string);
            componentId.setVersion(string2);
            this.componentIdsList.add(componentId);
        }

        public void setReleaseId(String string) {
            this.releaseId = string;
        }
    }
}

