/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.install_task.command.RequirementsDefault;
import com.mathworks.install_task.command.RequirementsUnix;
import com.mathworks.install_task.command.RequirementsWindows;
import com.mathworks.installwizard.command.AbstractCommandStepFactory;
import com.mathworks.installwizard.command.DependencyChecker;
import com.mathworks.installwizard.command.DependencyCheckerImpl;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.command.InstallCommandStepFactoryBat;
import com.mathworks.installwizard.command.InstallCommandStepFactoryLinux;
import com.mathworks.installwizard.command.InstallCommandStepFactoryMac;
import com.mathworks.installwizard.command.InstallCommandStepFactoryWindows;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.hyperlink.InstallAndLicensingHyperlinkProvider;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.activationws.client.ActivationService;
import com.mathworks.mlwebservices.webserviceproxy.AuthenticationWSClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.DDUXWSClientProxy;
import com.mathworks.mlwebservices.webserviceproxy.DWSRestClientProxy;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webservices.ddux.client.installer.FIKInstallerDDUXSettingsRequest;
import com.mathworks.webservices.ddux.client.installer.FIKInstallerDDUXSettingsResponse;
import com.mathworks.webservices.ddux.client.installer.InstallerDDUXSettingsClient;
import com.mathworks.webservices.ddux.client.installer.InstallerDDUXSettingsRequest;
import com.mathworks.webservices.ddux.client.installer.InstallerDDUXSettingsResponse;
import com.mathworks.webservices.ddux.model.PingResponse;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.worker.WorkerFactory;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public class InstallWizardModule
extends AbstractModule {
    public static final String CLIENT_STRING = "clientString";
    public static final String CONTROLLING_PRODUCTS = "controllingProducts";
    public static final String ARCH_STRING = "archString";

    protected void configure() {
        this.bind(DependencyChecker.class).to(DependencyCheckerImpl.class);
        this.bind(InstallerDDUXSettingsClient.class).to(NoOpDDUXSettingsClient.class);
    }

    @Provides
    static InstallCommandStepFactory getInstallCommandStepFactory(DWSRestClientProxy dWSRestClientProxy, ActivationService activationService, ExecutorServiceManager executorServiceManager, InstallerBuilder installerBuilder, ExitHandler exitHandler, @Named(value="archString") String string, WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, @Named(value="clientString") String string2, @Named(value="controllingProducts") String[] stringArray, Machine machine, Platform platform, IO iO, DependencyChecker dependencyChecker, InstallerRequirements installerRequirements, Properties properties, WorkerFactory workerFactory, InstallConfiguration installConfiguration, HyperlinkProvider hyperlinkProvider, Downloader downloader, ProxyConfiguration proxyConfiguration, ProcessExecutor processExecutor, UsageDataCollector usageDataCollector, DDUXWSClientProxy dDUXWSClientProxy, AuthenticationWSClientProxy authenticationWSClientProxy) {
        ExecutorService executorService = executorServiceManager.getMultiThreadedExecutorService();
        AbstractCommandStepFactory abstractCommandStepFactory = platform.isWindows() ? new InstallCommandStepFactoryWindows(installerBuilder, wizardUI, exceptionHandler, executorService, exitHandler, activationService, dWSRestClientProxy, string2, stringArray, string, appLogger, machine, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, usageDataCollector, properties, dDUXWSClientProxy, authenticationWSClientProxy) : (platform.isMac() ? new InstallCommandStepFactoryMac(installerBuilder, wizardUI, exceptionHandler, executorService, exitHandler, activationService, dWSRestClientProxy, string2, stringArray, string, appLogger, machine, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, usageDataCollector, properties, dDUXWSClientProxy, authenticationWSClientProxy) : new InstallCommandStepFactoryLinux(installerBuilder, wizardUI, exceptionHandler, executorService, exitHandler, activationService, dWSRestClientProxy, string2, stringArray, string, appLogger, machine, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, usageDataCollector, properties, dDUXWSClientProxy, authenticationWSClientProxy));
        if (Boolean.valueOf(properties.getProperty("bat", "false")).booleanValue()) {
            return new InstallCommandStepFactoryBat(abstractCommandStepFactory);
        }
        return abstractCommandStepFactory;
    }

    @Provides
    static InstallerRequirements getInstallerRequirements(Platform platform, Properties properties) {
        if (Boolean.valueOf(properties.getProperty("bat", "false")).booleanValue()) {
            return new RequirementsDefault();
        }
        if (platform.isWindows()) {
            return new RequirementsWindows();
        }
        if (platform.isLinux() || platform.isMac()) {
            return new RequirementsUnix();
        }
        return new RequirementsDefault();
    }

    @Provides
    static Machine getMachine(File file) throws JNIException {
        return new MachineInfo(file.getAbsolutePath());
    }

    @Provides
    static File getLibDirectory(SourcePathProvider sourcePathProvider, Properties properties, Platform platform) {
        String string = properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        if (string == null) {
            string = sourcePathProvider.getSourcePath();
        }
        return new File(platform.getNativeLibraryPath(string));
    }

    @Provides
    @Named(value="archString")
    static String getArchString(Platform platform) {
        return platform.getArchString();
    }

    @Provides
    static HyperlinkProvider provideHyperlinkProvider(final InstallConfiguration installConfiguration) {
        return new InstallAndLicensingHyperlinkProvider(){

            protected String getClientIdentifier() {
                return installConfiguration.getHyperlinkClientIdentifier();
            }
        };
    }

    static class NoOpDDUXSettingsClient
    implements InstallerDDUXSettingsClient {
        NoOpDDUXSettingsClient() {
        }

        public InstallerDDUXSettingsResponse getSettings(InstallerDDUXSettingsRequest installerDDUXSettingsRequest) {
            return null;
        }

        public FIKInstallerDDUXSettingsResponse getSettingsForFIKInstaller(FIKInstallerDDUXSettingsRequest fIKInstallerDDUXSettingsRequest) {
            return null;
        }

        public PingResponse ping() {
            return null;
        }
    }
}

