/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard;

import com.mathworks.install.ComponentData;
import com.mathworks.install_impl.status.InstallStatusObserverAdapter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public final class ArchiveExaminer
extends InstallStatusObserverAdapter {
    private String currentComponent;
    private Map<String, List<String>> fileMap = new HashMap<String, List<String>>();
    private File destinationFolder;

    public ArchiveExaminer(File file) {
        this.destinationFolder = file;
    }

    public void addComponent(ComponentData componentData) {
        this.currentComponent = componentData.getName();
    }

    public void addFile(File file) {
        String string = file.getAbsolutePath().replace(this.destinationFolder.getAbsolutePath(), "");
        if (this.fileMap.containsKey(string)) {
            this.fileMap.get(string).add(this.currentComponent);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.currentComponent);
            this.fileMap.put(string, arrayList);
        }
    }

    public void finished() {
        FileWriter fileWriter = null;
        try {
            File file = File.createTempFile("mw_duplicate_component_entries", ".txt");
            fileWriter = new FileWriter(file);
            fileWriter.write(this.getStringToWrite());
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(fileWriter);
        }
    }

    private String getStringToWrite() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.fileMap.keySet()) {
            this.appendElementForKey(stringBuilder, string);
        }
        return stringBuilder.toString();
    }

    private void appendElementForKey(StringBuilder stringBuilder, String string) {
        List<String> list = this.fileMap.get(string);
        if (list.size() > 1) {
            ArchiveExaminer.appendFileElement(stringBuilder, string);
            ArchiveExaminer.appendComponents(stringBuilder, list);
        }
    }

    private static void appendComponents(StringBuilder stringBuilder, List<String> list) {
        ArchiveExaminer.appendComponent(stringBuilder, list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            ArchiveExaminer.appendComponent(stringBuilder, list.get(1));
        }
    }

    private static void appendFileElement(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append(':').append(System.getProperty("line.separator"));
    }

    private static StringBuilder appendComponent(StringBuilder stringBuilder, String string) {
        return stringBuilder.append('\t').append(FilenameUtils.removeExtension((String)string)).append(System.getProperty("line.separator"));
    }
}

