/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.net.url;

import com.mathworks.net.ssl.SSLContextFactory;
import com.mathworks.net.ssl.TrustStores;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

final class HttpsURLStreamHandler
extends URLStreamHandler {
    private static final Logger LOGGER = Logger.getLogger("com.mathworks.net.url");
    private final URLStreamHandler fSystemStreamHandler;
    private final SSLSocketFactory fSSLSocketFactory;

    HttpsURLStreamHandler(URLStreamHandler uRLStreamHandler) {
        SSLContextFactory sSLContextFactory = SSLContextFactory.getInstance(TrustStores.getSystemTrustStoreBuilder());
        SSLContext sSLContext = sSLContextFactory.getSSLContext();
        this.fSSLSocketFactory = sSLContext.getSocketFactory();
        this.fSystemStreamHandler = uRLStreamHandler;
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        try {
            URL uRL2 = new URL(uRL, "", this.fSystemStreamHandler);
            URLConnection uRLConnection = uRL2.openConnection();
            if (uRLConnection instanceof HttpsURLConnection) {
                this.configure((HttpsURLConnection)uRLConnection);
            }
            return uRLConnection;
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error(malformedURLException);
        }
    }

    @Override
    protected URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        try {
            URL uRL2 = new URL(uRL, "", this.fSystemStreamHandler);
            URLConnection uRLConnection = uRL2.openConnection(proxy);
            if (uRLConnection instanceof HttpsURLConnection) {
                this.configure((HttpsURLConnection)uRLConnection);
            }
            return uRLConnection;
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error(malformedURLException);
        }
    }

    private void configure(HttpsURLConnection httpsURLConnection) throws IOException {
        LOGGER.fine("Configuring SSLSocketFactory for HttpsURLConnection");
        httpsURLConnection.setSSLSocketFactory(this.fSSLSocketFactory);
    }
}

