/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.net.transport;

import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.net.transport.MWTransportClientPropertiesFactory;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheImpl;
import sun.net.www.protocol.http.AuthCacheValue;

public class ProxyTestThread
implements Runnable {
    private static final String PROPERTIES_FILE = "com/mathworks/net/resources/RES_urlenv_generated_props.properties";
    private static final String RELEASE_PROPERTY = "releasefamily";
    private static final int TIMEOUT = 5000;
    private static final Logger DEFAULT_LOGGER = Logger.getLogger("com.mathworks.net.transport");
    private Logger logger = DEFAULT_LOGGER;
    private String urlString = "https://www.mathworks.com";
    private String userAgent;
    private boolean success;
    private String matlabRelease = "MATLAB ";

    public ProxyTestThread() {
        Properties properties = new Properties();
        try (InputStream inputStream = ProxyTestThread.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            properties.load(inputStream);
            this.matlabRelease = this.matlabRelease + properties.getProperty(RELEASE_PROPERTY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProxyTestThread(String string, String string2) {
        this(string2);
        this.urlString = string;
    }

    public ProxyTestThread(String string) {
        this();
        this.userAgent = string;
    }

    public ProxyTestThread(Logger logger) {
        this();
        this.logger = logger;
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setUrlString(String string) {
        this.urlString = string;
    }

    @Override
    public void run() {
        try {
            MWTransportClientProperties mWTransportClientProperties = MWTransportClientPropertiesFactory.create("http", this.logger);
            URL uRL = new URL(this.urlString);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(mWTransportClientProperties.getProxy());
            String string = mWTransportClientProperties.getProxyPassword();
            String string2 = mWTransportClientProperties.getProxyUser();
            httpURLConnection.setDefaultUseCaches(false);
            if (this.userAgent != null) {
                httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
            } else {
                httpURLConnection.setRequestProperty("User-Agent", this.matlabRelease);
            }
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            if (!"".equalsIgnoreCase(string2) && !"".equalsIgnoreCase(string)) {
                AuthCacheValue.setAuthCache((AuthCache)new AuthCacheImpl());
            }
            httpURLConnection.setReadTimeout(5000);
            httpURLConnection.setConnectTimeout(5000);
            int n = httpURLConnection.getResponseCode();
            this.success = n == 200;
        }
        catch (Throwable throwable) {
            if (this.logger == DEFAULT_LOGGER) {
                this.logger.log(Level.SEVERE, "Errors must be handled by caller", throwable);
            }
            this.logger.log(Level.SEVERE, "", throwable);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getClientString() {
        return this.userAgent;
    }

    public void setClientString(String string) {
        this.userAgent = string;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

