/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.net.transport;

import com.mathworks.net.transport.DefaultComboTCP;
import com.mathworks.net.transport.DefaultTmwTCP;
import com.mathworks.net.transport.MWTransportAuthenticator;
import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.net.transport.TransportClientPropertiesError;
import java.net.Authenticator;
import java.util.Hashtable;
import java.util.logging.Logger;

public class MWTransportClientPropertiesFactory {
    public static final String httpProtocolKey = "http";
    public static final String httpsProtocolKey = "https";
    public static final String ftpProtocolKey = "ftp";
    private static final Logger DEFAULT_LOGGER;
    private static Logger logger;
    private static Hashtable<String, Class> defaults;
    private static Hashtable<String, Class> cache;
    private static boolean setAsDefaultAuthenticatorEnabled;

    public static void setClientPropertiesClass(String string, Class clazz) {
        cache.put(string, clazz);
    }

    public static MWTransportClientProperties create(String string) {
        MWTransportClientProperties mWTransportClientProperties;
        Class clazz = cache.get(string);
        if (clazz == null) {
            clazz = defaults.get(string);
        }
        if (clazz == null) {
            return new TransportClientPropertiesError(string);
        }
        try {
            mWTransportClientProperties = (MWTransportClientProperties)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return new TransportClientPropertiesError(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            return new TransportClientPropertiesError(string);
        }
        MWTransportClientPropertiesFactory.setAsDefaultAuthenticatorIfEnabled(mWTransportClientProperties);
        return mWTransportClientProperties;
    }

    private static void setAsDefaultAuthenticatorIfEnabled(MWTransportClientProperties mWTransportClientProperties) {
        if (setAsDefaultAuthenticatorEnabled) {
            Authenticator.setDefault(new MWTransportAuthenticator(mWTransportClientProperties));
        }
    }

    public static MWTransportClientProperties create() {
        return MWTransportClientPropertiesFactory.create(DefaultComboTCP.protocolKey);
    }

    public static MWTransportClientProperties create(String string, Logger logger) {
        MWTransportClientPropertiesFactory.logger = logger;
        return MWTransportClientPropertiesFactory.create(string);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        MWTransportClientPropertiesFactory.logger = logger;
    }

    public static void disableSetAsDefaultAuthenticator() {
        setAsDefaultAuthenticatorEnabled = false;
    }

    public static void enableSetAsDefaultAuthenticator() {
        setAsDefaultAuthenticatorEnabled = true;
    }

    static {
        logger = DEFAULT_LOGGER = Logger.getLogger("com.mathworks.net.transport");
        defaults = new Hashtable();
        cache = new Hashtable();
        setAsDefaultAuthenticatorEnabled = true;
        defaults.put(httpProtocolKey, DefaultTmwTCP.class);
        defaults.put(httpsProtocolKey, DefaultTmwTCP.class);
        defaults.put(ftpProtocolKey, DefaultTmwTCP.class);
        defaults.put(DefaultComboTCP.protocolKey, DefaultTmwTCP.class);
    }
}

