/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.net.ssl;

import com.mathworks.net.ssl.NativeSystemTrustStore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

public final class TrustStores {
    private static final Logger LOGGER = Logger.getLogger("com.mathworks.net.ssl");

    private TrustStores() {
    }

    public static KeyStore.Builder getSystemTrustStoreBuilder() {
        return new FromSystemBuilder();
    }

    public static KeyStore getSystemTrustStore() throws KeyStoreException {
        return TrustStores.getSystemTrustStoreBuilder().getKeyStore();
    }

    public static KeyStore.Builder getJRETrustStoreBuilder() {
        File file = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts").toFile();
        return KeyStore.Builder.newInstance("JKS", Security.getProvider("SUN"), file, new KeyStore.PasswordProtection(null));
    }

    public static KeyStore getJRETrustStore() throws KeyStoreException {
        return TrustStores.getJRETrustStoreBuilder().getKeyStore();
    }

    private static KeyStore emptyKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new Error(exception);
        }
    }

    private static class FromSystemBuilder
    extends KeyStore.Builder {
        private FromSystemBuilder() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public KeyStore getKeyStore() throws KeyStoreException {
            try (NativeSystemTrustStore nativeSystemTrustStore = new NativeSystemTrustStore();){
                KeyStore keyStore = TrustStores.emptyKeyStore();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                for (byte[] byArray : nativeSystemTrustStore) {
                    try {
                        if (byArray == null) continue;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                        keyStore.setCertificateEntry(x509Certificate.getIssuerX500Principal().getName(), x509Certificate);
                    }
                    catch (CertificateException certificateException) {
                        LOGGER.fine("Failed to import certificate: " + certificateException.getMessage());
                    }
                }
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException);
            }
        }

        @Override
        public KeyStore.ProtectionParameter getProtectionParameter(String string) {
            return new KeyStore.PasswordProtection(null);
        }
    }
}

