/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.net.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLContextFactory {
    private static final Logger LOGGER = Logger.getLogger("com.mathworks.net.ssl");

    public abstract SSLContext getSSLContext();

    public static SSLContextFactory getInstance(final KeyStore.Builder builder) {
        return new SSLContextFactory(){

            @Override
            public SSLContext getSSLContext() {
                try {
                    LOGGER.fine("Creating new SSLContext");
                    SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(builder.getKeyStore());
                    sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
                    LOGGER.fine("Created new SSLContext");
                    return sSLContext;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new Error(noSuchAlgorithmException);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new Error(generalSecurityException);
                }
            }
        };
    }
}

