/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import java.awt.Font;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class AbstractPrintableEditorPane
extends JEditorPane {
    private static final String DUMMY_TAG_TEXT = "dummy";

    @Override
    public final void setText(String string) {
        super.setText(AbstractPrintableEditorPane.getTextForEditorPane(string, this));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        Document document = this.getDocument();
        int n = document.getLength();
        try {
            String string2 = document.getText(1, n);
            accessibleContext.setAccessibleName(string2.trim());
        }
        catch (BadLocationException badLocationException) {
            this.handleException(badLocationException);
        }
    }

    @Override
    public final String getSelectedText() {
        String string = super.getSelectedText();
        if (string != null) {
            return string.replaceAll("\\\\ ", "\\\\").replaceAll("/ ", "/");
        }
        return "";
    }

    protected abstract void handleException(Exception var1);

    private static String getTextForEditorPane(String string, JComponent jComponent) {
        String string2 = string.replaceAll("\n", "<br>");
        string2 = AbstractPrintableEditorPane.addDummyTagsIfNecessary(string2);
        String string3 = AbstractPrintableEditorPane.getHeadText(jComponent);
        return string3 + string2;
    }

    private static String addDummyTagsIfNecessary(String string) {
        String string2 = ">" + string + "<";
        string2 = string2.replaceAll("\\\\(?=[^<>]*<)", "\\\\<dummy>");
        string2 = string2.replaceAll("/(?=[^<>]*<)", "/<dummy>");
        int n = string2.length();
        string2 = string2.substring(1, n - 1);
        return string2;
    }

    private static String getHeadText(JComponent jComponent) {
        String string = "#" + Integer.toHexString(UIManager.get("Label.foreground").hashCode()).substring(2);
        Font font = jComponent.getFont();
        String string2 = "<html><head><style type=\"text/css\">body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt }</style></head><body text=\"" + string + "\">";
        if (font.isBold()) {
            string2 = string2.concat("<b>");
        }
        return string2;
    }
}

