/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.services.AbstractServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.mlwebservices.LoginService;
import com.mathworks.webservices.authenticationws.client.rest.response.Token;
import com.mathworks.webservices.client.core.MathWorksClientException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class LoginVerifyThread
extends AbstractServiceThread<String> {
    private final LoginService fLoginService;
    private final String verificationCode;
    private String mfaPendingToken;
    private String fToken;
    private Lock fLock = new ReentrantLock();

    LoginVerifyThread(ServiceThreadView serviceThreadView, LoginService loginService, String string, String string2) {
        super(serviceThreadView, "dialog.title", "dialog.service", false);
        this.fLoginService = loginService;
        this.verificationCode = string;
        this.mfaPendingToken = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LoginService loginService = this.fLoginService;
        if (loginService.isConnected()) {
            try {
                Token token = loginService.loginVerify(this.verificationCode, this.mfaPendingToken, this.getClientString());
                this.setStatus(ServiceThreadState.SUCCESS);
                try {
                    this.fLock.lock();
                    this.fToken = token.getTokenString();
                }
                finally {
                    this.fLock.unlock();
                }
            }
            catch (MathWorksClientException mathWorksClientException) {
                this.setStatus(ServiceThreadState.FAIL);
                this.showError(mathWorksClientException.getErrorCode(), mathWorksClientException.getMessage());
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
            finally {
                if (this.isCancelled()) {
                    try {
                        this.fLock.lock();
                        this.fToken = null;
                    }
                    finally {
                        this.fLock.unlock();
                    }
                } else {
                    this.finish();
                }
            }
        } else {
            this.showConnectionError();
            this.finish();
        }
    }

    @Override
    public String getResult() {
        String string;
        try {
            this.fLock.lock();
            string = this.fToken;
        }
        finally {
            this.fLock.unlock();
        }
        return string;
    }
}

