/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.services.AbstractServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.LoginService;
import com.mathworks.webservices.authenticationws.client.rest.response.LoginResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.MfaPendingToken;
import com.mathworks.webservices.authenticationws.client.rest.response.Token;
import com.mathworks.webservices.client.core.MathWorksClientException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class LoginThread
extends AbstractServiceThread<String> {
    private final LoginService fLoginService;
    private final Account account;
    private final String fEmailAddress;
    private final String fPassword;
    private String fToken;
    private Lock fLock = new ReentrantLock();

    LoginThread(ServiceThreadView serviceThreadView, LoginService loginService, String string, String string2, Account account) {
        super(serviceThreadView, "dialog.title", "dialog.service", false);
        this.fEmailAddress = string;
        this.fPassword = string2;
        this.fLoginService = loginService;
        this.account = account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LoginService loginService = this.fLoginService;
        if (loginService.isConnected()) {
            try {
                LoginResponse loginResponse = loginService.login(this.fEmailAddress, this.fPassword, this.getClientString());
                this.setStatus(ServiceThreadState.SUCCESS);
                this.account.setRequiresCodeVerification(loginResponse.requiresCodeVerification());
                if (!this.account.isCodeVerificationRequired()) {
                    Token token = loginResponse.getToken();
                    try {
                        this.fLock.lock();
                        this.fToken = token.getTokenString();
                    }
                    finally {
                        this.fLock.unlock();
                    }
                    this.account.setSecurityToken(this.fToken);
                    this.account.setTwoSVMessage("");
                }
                MfaPendingToken mfaPendingToken = loginResponse.getMfaPendingToken();
                this.account.setSecurityToken(mfaPendingToken.getTokenString());
                this.account.setTwoSVMessage(mfaPendingToken.getMessage());
            }
            catch (MathWorksClientException mathWorksClientException) {
                this.setStatus(ServiceThreadState.FAIL);
                this.showError(mathWorksClientException.getErrorCode(), mathWorksClientException.getMessage());
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
            finally {
                if (this.isCancelled()) {
                    try {
                        this.fLock.lock();
                        this.fToken = null;
                    }
                    finally {
                        this.fLock.unlock();
                    }
                } else {
                    this.finish();
                }
            }
        } else {
            this.showConnectionError();
            this.finish();
        }
    }

    @Override
    public String getResult() {
        String string;
        try {
            this.fLock.lock();
            string = this.fToken;
        }
        finally {
            this.fLock.unlock();
        }
        return string;
    }
}

