/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.services.AwsActivationServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.internal.activationws.client.MWAProfileResponse;
import com.mathworks.internal.activationws.client.MWAResponse;
import com.mathworks.mlwebservices.ActivationService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class CreateProfileForOtherThread
extends AwsActivationServiceThread<String> {
    private String fToken;
    private Lock tokenLock = new ReentrantLock();
    private final String token;
    private final String email;
    private final String firstName;
    private final String lastName;
    private final String activationKey;

    CreateProfileForOtherThread(ServiceThreadView serviceThreadView, ActivationService activationService, String string, String string2, String string3, String string4, String string5) {
        super(serviceThreadView, activationService, "dialog.title", "dialog.service");
        this.token = string;
        this.email = string2;
        this.firstName = string3;
        this.lastName = string4;
        this.activationKey = string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        ActivationService activationService = this.getActivationService();
        if (activationService.isConnected()) {
            String string = this.getClientString();
            try {
                MWAProfileResponse mWAProfileResponse = activationService.createProfileForOther(this.token, this.email, this.firstName, this.lastName, this.activationKey, string);
                ServiceThreadState serviceThreadState = this.processResponse((MWAResponse)mWAProfileResponse);
                this.setStatus(serviceThreadState);
                if (this.getStatus() != ServiceThreadState.SUCCESS) return;
                this.tokenLock.lock();
                try {
                    this.fToken = mWAProfileResponse.getSecurityToken();
                    return;
                }
                finally {
                    this.tokenLock.unlock();
                }
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
                return;
            }
            finally {
                if (this.isCancelled()) {
                    this.tokenLock.lock();
                    try {
                        this.fToken = null;
                    }
                    finally {
                        this.tokenLock.unlock();
                    }
                } else {
                    this.finish();
                }
            }
        } else {
            this.showConnectionError();
            this.finish();
        }
    }

    @Override
    public String getResult() {
        String string;
        this.tokenLock.lock();
        try {
            string = this.fToken;
        }
        finally {
            this.tokenLock.unlock();
        }
        return string;
    }
}

