/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.logging;

import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.logging.AppLogFormatter;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.AppMemoryTarget;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;

public abstract class AbstractAppLogger
implements AppLogger {
    private static final Level DEFAULT_LEVEL = Level.INFO;
    protected Logger theJavaLogger;
    private FileHandler fileHandler = null;
    private ConsoleHandler consoleHandler = null;
    private MemoryHandler memHandler = null;
    private AppMemoryTarget localMemTarget = null;
    private String path;
    private String defaultLogFile;

    public AbstractAppLogger(boolean bl) {
        this.initLogger(bl, this.getDefaultOutputLog());
    }

    public AbstractAppLogger(boolean bl, String string) {
        this.initLogger(bl, string);
    }

    private void initLogger(boolean bl, String string) {
        this.theJavaLogger = Logger.getLogger("com.mathworks.instutil.logging");
        this.configLogger();
        this.printLogHeader(bl);
        this.defaultLogFile = string;
    }

    private void printLogHeader(boolean bl) {
        this.logMsg("##################################################################");
        this.logMsg("#");
        this.logMsg("# Today's Date: ");
        this.logMsg(new Date().toString());
        this.logMsg("");
        this.logMsg("System Info");
        this.logMsg("OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version"));
        this.logMsg("Arch: " + System.getProperty("os.arch"));
        this.logMsg("Data Model: " + System.getProperty("sun.arch.data.model"));
        this.logMsg("Language: " + Locale.getDefault().getLanguage());
        this.logMsg("Java Vendor: " + System.getProperty("java.vendor"));
        this.logMsg("Java Home: " + System.getProperty("java.home"));
        this.logMsg("Java Version: " + System.getProperty("java.version"));
        this.logMsg("Java VM Name: " + System.getProperty("java.vm.name"));
        if (bl) {
            this.logMsg("Java Class Path: " + System.getProperty("java.class.path"));
        } else {
            this.logMsg("Java Class Path: Skipped ");
        }
        this.logMsg("User Name: " + System.getProperty("user.name"));
        this.logMsg("Current Directory: " + System.getProperty("user.dir"));
    }

    @Override
    public synchronized void enableFileLogging(String string) throws IOException {
        this.path = string;
        if (this.fileHandler != null) {
            this.fileHandler.close();
            this.theJavaLogger.removeHandler(this.fileHandler);
        }
        this.fileHandler = new FileHandler(string, 0, 1, true);
        this.fileHandler.setLevel(DEFAULT_LEVEL);
        this.fileHandler.setFormatter(new AppLogFormatter());
        this.theJavaLogger.addHandler(this.fileHandler);
        this.theJavaLogger.removeHandler(this.memHandler);
        this.memHandler = null;
    }

    @Override
    public synchronized void enableDefaultFileLogging() {
        this.enableLoggingToSpecifiedFile(this.defaultLogFile);
    }

    @Override
    public synchronized void enableLoggingToSpecifiedFile(String string) {
        FileIO fileIO = new FileIO(new FilePermissionsUtil());
        try {
            String string2 = new File(string).getAbsolutePath();
            fileIO.mkdirs(new File(string2).getParent());
            this.defaultLogFile = string2;
            this.enableFileLogging(string2);
            this.dumpStoredMessages();
        }
        catch (IOException iOException) {
            String string3 = this.defaultLogFile;
            if (!string.equalsIgnoreCase(string3)) {
                try {
                    fileIO.mkdirs(new File(string3).getParent());
                    this.enableFileLogging(string3);
                }
                catch (IOException iOException2) {
                    System.err.println(InstutilResourceKeys.ERROR_CREATING_DEFAULT_OUTPUTFILE.getString(string3, iOException2.getMessage()));
                }
            }
            System.err.println(InstutilResourceKeys.ERROR_CREATING_OUTPUTFILE.getString(string, iOException.getMessage()));
        }
    }

    @Override
    public String getDefaultOutputLog() {
        String string = System.getProperty("user.name");
        String string2 = InstutilResourceKeys.DEFAULT_LOG_FILE_NAME.getString(string);
        return new File(System.getProperty("java.io.tmpdir"), string2).getAbsolutePath();
    }

    @Override
    public synchronized void disableFileLogging() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
        this.theJavaLogger.removeHandler(this.fileHandler);
    }

    @Override
    public synchronized boolean isFileLoggingEnabled() {
        Handler[] handlerArray = this.theJavaLogger.getHandlers();
        if (handlerArray != null && handlerArray.length > 0) {
            for (Handler handler : handlerArray) {
                if (handler == null || !handler.equals(this.fileHandler)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void enableConsoleLogging() {
        if (this.consoleHandler != null) {
            this.consoleHandler.close();
            this.theJavaLogger.removeHandler(this.consoleHandler);
        }
        this.consoleHandler = new StdOutConsoleHandler();
        this.consoleHandler.setLevel(DEFAULT_LEVEL);
        this.consoleHandler.setFormatter(new AppLogFormatter());
        this.theJavaLogger.addHandler(this.consoleHandler);
        this.theJavaLogger.removeHandler(this.memHandler);
        this.memHandler = null;
    }

    @Override
    public synchronized void dumpStoredMessages() {
        if (this.memHandler == null) {
            String[] stringArray;
            for (String string : stringArray = this.localMemTarget.popMessages()) {
                this.logMsg(string);
            }
        }
    }

    @Override
    public void setLevel(Level level) throws SecurityException {
        Handler[] handlerArray;
        this.theJavaLogger.setLevel(level);
        for (Handler handler : handlerArray = this.theJavaLogger.getHandlers()) {
            handler.setLevel(level);
        }
    }

    @Override
    public synchronized void safeLogMsg(String string) {
        if (!this.isFileLoggingEnabled()) {
            this.enableDefaultFileLogging();
        }
        this.logMsg(string);
    }

    @Override
    public void logMsg(String string) {
        this.logLevel(Level.INFO, string);
    }

    @Override
    public void debugMsg(String string) {
        this.logLevel(Level.FINE, string);
    }

    @Override
    public final void errorMsg(String string, Throwable throwable) {
        this.theJavaLogger.log(Level.ALL, string, throwable);
    }

    private void logLevel(Level level, String string) {
        this.theJavaLogger.log(level, string);
    }

    @Override
    public synchronized void close() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
        if (this.consoleHandler != null) {
            this.consoleHandler.close();
        }
        if (this.memHandler != null) {
            this.memHandler.close();
        }
        this.theJavaLogger.removeHandler(this.fileHandler);
        this.theJavaLogger.removeHandler(this.consoleHandler);
        this.theJavaLogger.removeHandler(this.memHandler);
    }

    @Override
    public synchronized String getPath() {
        return this.path;
    }

    @Override
    public Logger getLogger() {
        return this.theJavaLogger;
    }

    private synchronized void configLogger() {
        this.theJavaLogger.setUseParentHandlers(false);
        this.theJavaLogger.setLevel(DEFAULT_LEVEL);
        this.theJavaLogger.setFilter(null);
        this.localMemTarget = new AppMemoryTarget();
        this.localMemTarget.setFormatter(new AppLogFormatter());
        this.localMemTarget.setLevel(DEFAULT_LEVEL);
        this.memHandler = new MemoryHandler(this.localMemTarget, 1000, DEFAULT_LEVEL);
        this.memHandler.setFormatter(new AppLogFormatter());
        this.memHandler.setLevel(DEFAULT_LEVEL);
        this.theJavaLogger.addHandler(this.memHandler);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private static class StdOutConsoleHandler
    extends ConsoleHandler {
        StdOutConsoleHandler() {
            this.setOutputStream(System.out);
        }
    }
}

