/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.TrusteeType;
import com.mathworks.instutil.licensefiles.LicenseFileLocation;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseFileWriter;
import com.mathworks.instutil.licensefiles.LicenseInfo;
import com.mathworks.instutil.licensefiles.LicenseUtility;
import com.mathworks.mlwebservices.Account;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicenseUtilityImpl
implements LicenseUtility {
    public static final String USER_BASED = "USER_BASED";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String PORT_NUMBER = "27000";
    public static final String DAEMON_MLM = "DAEMON MLM";
    public static final String SERVER = "SERVER";
    private static final String NO_HOSTID = "YOUR_HOSTID";
    private boolean writeAddOnsTrialToUserProfile = false;
    private LicenseFileWriter app;
    private String licenseString;
    private String entitlementID;
    private Account accountForOther;
    private boolean dcLicense = false;
    private final FolderUtils folderUtils = new FolderUtilsImpl();

    public LicenseUtilityImpl(LicenseFileWriter licenseFileWriter, String string, String string2) {
        this.app = licenseFileWriter;
        this.licenseString = string;
        this.entitlementID = string2;
    }

    public LicenseUtilityImpl(LicenseFileWriter licenseFileWriter, String string, String string2, Account account) {
        this(licenseFileWriter, string, string2);
        this.accountForOther = account;
    }

    public LicenseUtilityImpl(LicenseFileWriter licenseFileWriter, String string) {
        this(licenseFileWriter, string, "0");
    }

    public LicenseUtilityImpl(LicenseFileWriter licenseFileWriter, String string, String string2, boolean bl) {
        this(licenseFileWriter, string, string2);
        this.writeAddOnsTrialToUserProfile = bl;
    }

    String getFlexPath() {
        String string = this.app.getRootDir();
        LicenseFileLocation licenseFileLocation = this.app.getLicenseLocationFactory().getNetworkServerLicenseLocation(string);
        return licenseFileLocation.getLicenseLocation();
    }

    String getOptionsFilePath() {
        return this.getFlexPath() + File.separator + "mlm.opt";
    }

    void createOptsFile(LicenseFileParser licenseFileParser, File file) throws IOException {
        String string = System.getProperty(LINE_SEPARATOR);
        String string2 = InstutilResourceKeys.OPTIONSFILECOMMENT.getString(string);
        List<String> list = this.getFeatureNames(licenseFileParser);
        String string3 = InstutilResourceKeys.OPTIONSFILEINCLUDE.getBundleString();
        MessageFormat messageFormat = new MessageFormat(string3);
        String string4 = this.app.getUName();
        for (String string5 : list) {
            if (string5.equalsIgnoreCase("TMW_Archive")) continue;
            string2 = string2.concat(messageFormat.format(new Object[]{string5, string4, string}));
        }
        try {
            this.app.getIO().writeStringToFile(string2, file, 0L, 420, new IOObserver[0]);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFeatureNames(LicenseFileParser licenseFileParser) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringReader stringReader = null;
        try {
            stringReader = new StringReader(this.licenseString);
            Collection<LicenseInfo> collection = licenseFileParser.parseLicenseFile(stringReader);
            for (LicenseInfo licenseInfo : collection) {
                arrayList.add(licenseInfo.getFeatureName());
            }
        }
        finally {
            if (stringReader != null) {
                try {
                    ((Reader)stringReader).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    boolean createOptsFile(LicenseFileParser licenseFileParser) {
        boolean bl = true;
        String string = this.getOptionsFilePath();
        File file = new File(string);
        if (!file.isFile()) {
            try {
                this.createOptsFile(licenseFileParser, file);
            }
            catch (IOException iOException) {
                this.app.exception(iOException, false);
                bl = false;
            }
        }
        return bl;
    }

    String getServerLicense(LicenseFileParser licenseFileParser) {
        String string = this.licenseString;
        string = this.addDaemonMLM(string);
        string = this.addServerLine(licenseFileParser, string);
        return string;
    }

    String addServerLine(LicenseFileParser licenseFileParser, String string) {
        if (!licenseFileParser.containsServerLine(this.licenseString)) {
            string = "SERVER " + this.app.getHostName() + " " + this.getHostidFromComment() + " " + PORT_NUMBER + " " + System.getProperty(LINE_SEPARATOR) + string;
        }
        return string;
    }

    String addDaemonMLM(String string) {
        if (!string.contains(DAEMON_MLM)) {
            string = "DAEMON MLM \"" + this.getDaemonPath() + '\"' + this.getOptionsString() + System.getProperty(LINE_SEPARATOR) + string;
        }
        return string;
    }

    String getOptionsString() {
        if (this.isNetworkNamedUser()) {
            return " options=\"" + this.getOptionsFilePath() + '\"';
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getClientLicense(LicenseFileParser licenseFileParser, String string) {
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder("");
        BufferedReader bufferedReader = null;
        String string3 = System.getProperty(LINE_SEPARATOR);
        try {
            String string4;
            bufferedReader = new BufferedReader(new StringReader(string));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (!licenseFileParser.containsServerLine(string4)) continue;
                stringBuilder.append(string4).append(string3);
            }
            if (stringBuilder.length() == 0) {
                string2 = InstutilResourceKeys.CLIENTTEMPLATE.getString(string3);
                String string5 = this.app.getRootDir();
                LicenseFileLocation licenseFileLocation = this.app.getLicenseLocationFactory().getNetworkClientLicenseLocation(string5);
                String string6 = licenseFileLocation.getLicenseLocation();
                String string7 = licenseFileLocation.getLicenseName();
                String string8 = new File(string6, string7).getAbsolutePath();
                String string9 = InstutilResourceKeys.SERVERLINEXCTITLE.getBundleString();
                String string10 = InstutilResourceKeys.SERVERLINEEXCEPTION.getBundleString();
                MessageFormat messageFormat = new MessageFormat(string10);
                String string11 = messageFormat.format(new Object[]{string8});
                this.app.sendMessage(string9, string11);
            } else {
                string2 = stringBuilder.toString() + "USE_SERVER" + string3;
            }
        }
        catch (IOException iOException) {
            this.app.exception(iOException, false);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.app.exception(iOException, false);
                }
            }
        }
        return string2;
    }

    private String getDaemonPath() {
        PlatformImpl platformImpl = new PlatformImpl();
        if (platformImpl.isWindows()) {
            String string = platformImpl.is64Bit() ? "win64" : "win32";
            return this.getFlexPath() + File.separator + string + File.separator + "mlm.exe";
        }
        return this.getFlexPath() + File.separator + "MLM";
    }

    boolean isDCLicense() {
        return this.dcLicense;
    }

    void setDCLicense(boolean bl) {
        this.dcLicense = bl;
    }

    @Override
    public boolean installLicense(LicenseFileParser licenseFileParser) {
        boolean bl = false;
        String string = this.app.getRootDir();
        String string2 = InstallerUtilities.getLibDirPath(string);
        String string3 = this.app.getUName();
        if (this.app.isNetworkBased(this.licenseString)) {
            boolean bl2 = true;
            String string4 = this.licenseString;
            if (this.app.isNetworkServer()) {
                LicenseFileLocation licenseFileLocation = this.app.getLicenseLocationFactory().getNetworkServerLicenseLocation(string);
                string4 = this.getServerLicense(licenseFileParser);
                bl2 = this.writeLicenseFile(licenseFileLocation, string4);
            }
            boolean bl3 = true;
            if (this.app.isNetworkClient(licenseFileParser, string4)) {
                LicenseFileLocation licenseFileLocation = this.app.getLicenseLocationFactory().getNetworkClientLicenseLocation(string);
                String string5 = this.getClientLicense(licenseFileParser, string4);
                bl3 = this.writeLicenseFile(licenseFileLocation, string5);
            }
            bl = bl3 && bl2;
        } else {
            String string6 = InstutilResourceKeys.RELEASE.getBundleString();
            StringReader stringReader = new StringReader(this.licenseString);
            Collection<LicenseInfo> collection = licenseFileParser.parseLicenseFile(stringReader);
            if (!collection.isEmpty()) {
                LicenseFileLocation licenseFileLocation;
                Iterator<LicenseInfo> iterator = collection.iterator();
                LicenseInfo licenseInfo = iterator.next();
                String string7 = licenseInfo.getLicenseNumber();
                if (licenseInfo.isTSURLicense()) {
                    if (this.writeAddOnsTrialToUserProfile) {
                        licenseFileLocation = this.app.getLicenseLocationFactory().getAddOnsTrialLicenseLocation(string2, string6, string7, this.entitlementID);
                    } else {
                        if ("0".equalsIgnoreCase(this.entitlementID)) {
                            this.entitlementID = Integer.toString(licenseInfo.getEntitlementId());
                        }
                        licenseFileLocation = this.app.getLicenseLocationFactory().getStandaloneTSURLicenseLocation(string, string6, this.entitlementID);
                    }
                } else if (licenseInfo.isDCLicense()) {
                    this.setDCLicense(true);
                    licenseFileLocation = this.app.getLicenseLocationFactory().getMachineLicenseLocation(string, string6, string7);
                } else {
                    licenseFileLocation = licenseInfo.isLockedToUserLoginName(string3) ? this.app.getLicenseLocationFactory().getUserLicenseLocation(string2, string6, string7) : this.app.getLicenseLocationFactory().getOtherUserLicenseLocation(string, string6, string7);
                }
                bl = this.writeLicenseFile(licenseFileLocation, this.licenseString);
            } else {
                String string8 = InstutilResourceKeys.LICENSEERRORTITLE.getBundleString();
                String string9 = InstutilResourceKeys.LICENSEERROR.getBundleString();
                this.app.sendMessage(string8, string9);
            }
        }
        if (bl && this.app.isNetworkServer() && this.isNetworkNamedUser()) {
            bl = this.createOptsFile(licenseFileParser);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLicenseFile(LicenseFileLocation licenseFileLocation, String string) {
        boolean bl = false;
        String string2 = licenseFileLocation.getLicenseLocation() + File.separator + licenseFileLocation.getLicenseName();
        byte[] byArray = string.getBytes();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string2);
            this.folderUtils.createParentIfNecessary(file);
            if (this.folderUtils.hasParent(file)) {
                FilePermissions filePermissions = this.app.getFilePermissionsUtility();
                filePermissions.setFileWritable(file, true);
                fileOutputStream = new FileOutputStream(file, false);
                WritableByteChannel writableByteChannel = Channels.newChannel(fileOutputStream);
                writableByteChannel.write(byteBuffer);
                writableByteChannel.close();
                bl = this.ensureFilePermissions(file);
                bl = true;
            } else {
                String string3 = InstutilResourceKeys.LICENSEERRORTITLE2.getBundleString();
                String string4 = InstutilResourceKeys.LICENSEDIRERROR.getString(this.folderUtils.getParent(file));
                this.app.sendMessage(string3, string4);
            }
        }
        catch (IOException iOException) {
            Object[] objectArray;
            String string5 = InstutilResourceKeys.LICENSEERRORTITLE2.getBundleString();
            String string6 = iOException.getMessage();
            if (string6 == null && null != (objectArray = iOException.getCause())) {
                string6 = objectArray.getMessage();
            }
            objectArray = new Object[]{string2, string6};
            String string7 = InstutilResourceKeys.LICENSEFILEERROR.getString(objectArray);
            this.app.sendMessage(string5, string7);
        }
        catch (Throwable throwable) {
            this.app.exception(throwable, false);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.app.exception(iOException, false);
                }
            }
        }
        return bl;
    }

    boolean allowOthersUpdate(File file, String string) {
        boolean bl = true;
        FilePermissions filePermissions = this.app.getFilePermissionsUtility();
        if (filePermissions != null && !(bl = filePermissions.allowOtherUserUpdate(file, string))) {
            String string2 = InstutilResourceKeys.PERMISSIONERRROR.getString(string);
            this.app.exception(new Throwable(string2), true);
            string = "EVERYONE";
            long l = 0x10000000L;
            filePermissions.allowTrusteeTypeUpdate(file, TrusteeType.TRUSTEE_IS_WELL_KNOWN_GROUP, string, l);
        }
        return bl;
    }

    boolean ensureFilePermissions(File file) {
        boolean bl = true;
        String string = "";
        PlatformImpl platformImpl = new PlatformImpl();
        if (this.accountForOther != null) {
            string = this.accountForOther.getUserName();
            if (string != null && !string.equalsIgnoreCase("") || string != null && string.equalsIgnoreCase("") && this.isDCLicense() && !platformImpl.isWindows()) {
                bl = this.allowOthersUpdate(file, string);
            }
        } else if (this.isDCLicense() && !platformImpl.isWindows()) {
            bl = this.allowOthersUpdate(file, string);
        }
        return bl;
    }

    boolean isNetworkNamedUser() {
        return this.app.isNetworkBased(this.licenseString) && this.licenseString.contains(USER_BASED);
    }

    String getHostidFromComment() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("HostID: ([^\\s]+)");
        Matcher matcher = pattern.matcher(this.licenseString);
        while (matcher.find()) {
            string = matcher.group(1);
            arrayList.add(string);
        }
        string = this.app.getEthernetAddress();
        String string2 = this.app.getIpAddress();
        String string3 = NO_HOSTID;
        for (String string4 : arrayList) {
            Pattern pattern2 = Pattern.compile("[^=]*=(.+)");
            Matcher matcher2 = pattern2.matcher(string4);
            String string5 = matcher2.find() ? matcher2.group(1) : string4;
            if (!string5.equalsIgnoreCase(string) && !string5.equalsIgnoreCase(string2)) continue;
            string3 = string4;
            break;
        }
        if (string3.equalsIgnoreCase(NO_HOSTID) && arrayList.size() == 1) {
            string3 = (String)arrayList.get(0);
        }
        return string3;
    }

    void setAccountForOther(Account account) {
        this.accountForOther = account;
    }

    String getEntitlementId() {
        return this.entitlementID;
    }
}

