/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.InstutilResourceKeys;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class VersionInfo {
    private static final String VERSION_INFO_FILE_NAME = "VersionInfo.xml";
    private static final String EMPTY_STRING = "";
    private static final String UNDER_SCORE = "_";
    private static final String DEFAULT = "default";
    private static final String PRERELEASE_DESCRIPTION = "Prerelease";

    public static String getCurrentUpdateLevel(String string) {
        Element element = VersionInfo.getRootElement(string);
        String string2 = VersionInfo.getValue(element, "release");
        String string3 = VersionInfo.getValue(element, "description");
        if (!string3.isEmpty()) {
            string3 = string3.trim();
            string3 = string3.replaceAll("\\s", UNDER_SCORE);
            string2 = string2 + UNDER_SCORE + string3;
        }
        return string2;
    }

    public static String getUpdateLevelForDWS(String string) {
        boolean bl;
        String string2 = InstutilResourceKeys.RELEASE.getString(new Object[0]);
        String string3 = VersionInfo.getRelease(string);
        String string4 = VersionInfo.getCurrentUpdateLevel(string);
        boolean bl2 = string4.isEmpty();
        boolean bl3 = string2.equals(string3) && VersionInfo.getDescription(string).contains(PRERELEASE_DESCRIPTION);
        boolean bl4 = bl = !string2.equals(string3);
        if (bl2 || bl3 || bl) {
            return DEFAULT;
        }
        return string4;
    }

    public static String getRelease(String string) {
        Element element = VersionInfo.getRootElement(string);
        return VersionInfo.getValue(element, "release");
    }

    public static String getDescription(String string) {
        Element element = VersionInfo.getRootElement(string);
        return VersionInfo.getValue(element, "description");
    }

    public static int getCurrentUpdateLevelNumber(String string) {
        int n = 0;
        try {
            String string2 = VersionInfo.getCurrentUpdateLevel(string);
            n = VersionInfo.getUpdateNumberFromReleaseText(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int getUpdateNumberFromReleaseText(String string) {
        return Integer.valueOf(string.substring(string.lastIndexOf(UNDER_SCORE) + 1));
    }

    public static String getPrerelease(String string) {
        String string2 = EMPTY_STRING;
        Element element = VersionInfo.getRootElement(string);
        String string3 = VersionInfo.getValue(element, "description");
        if (VersionInfo.isPrerelease(string3)) {
            string2 = VersionInfo.getValue(element, "release").concat(UNDER_SCORE).concat(PRERELEASE_DESCRIPTION);
        }
        return string2;
    }

    public static boolean isPrerelease(String string) {
        return string.contains(PRERELEASE_DESCRIPTION);
    }

    public static String getVersion(String string) {
        Element element = VersionInfo.getRootElement(string);
        return VersionInfo.getValue(element, "version");
    }

    private static Element getRootElement(String string) {
        Element element = null;
        if (!string.isEmpty()) {
            File file = new File(string + File.separator + VERSION_INFO_FILE_NAME);
            element = null;
            if (file.exists() && !file.isDirectory()) {
                try {
                    SAXBuilder sAXBuilder = new SAXBuilder();
                    Document document = sAXBuilder.build(file);
                    element = document.getRootElement();
                }
                catch (IOException | JDOMException throwable) {
                    // empty catch block
                }
            }
        }
        return element;
    }

    private static String getValue(Element element, String string) {
        return element != null ? element.getChildText(string) : EMPTY_STRING;
    }
}

