/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.mathworks.instutil.ActivationServiceProxy;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.UpdateLicenseException;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseFileParserImpl;
import com.mathworks.instutil.licensefiles.LicenseFileWriter;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseLocationFactoryImpl;
import com.mathworks.instutil.licensefiles.LicenseUtilityFactory;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.AppLoggerImpl;
import com.mathworks.internal.activationws.client.ActivationService;
import com.mathworks.internal.activationws.client.MWAMachineAttribute;
import com.mathworks.internal.activationws.client.MWARefreshRightsResponse;
import com.mathworks.internal.activationws.client.MWAValidateResponse;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import java.io.File;
import java.net.Proxy;
import java.net.URL;
import java.util.Locale;

public final class UpdateLicenseUtility {
    private static final int REFRESH_REQUIRED = 1;
    private static final String RELEASE_STRING = InstutilResourceKeys.RELEASE.getString(new Object[0]);
    private static MachineInfo machineInfo;
    private static File libDir;
    private static AppLogger appLogger;

    private UpdateLicenseUtility() {
    }

    public static Boolean updateLicense(final String string, final File file, final String string2) throws UpdateLicenseException {
        Task<Boolean> task = new Task<Boolean>(){

            @Override
            public Boolean execute(File file2, ActivationService activationService, IO iO, MachineInfo machineInfo) throws UpdateLicenseException {
                boolean bl = true;
                MWAMachineAttribute[] mWAMachineAttributeArray = machineInfo.getMachineAttributes();
                String string4 = machineInfo.getUName();
                int n = Integer.parseInt(string);
                String string22 = Locale.getDefault().toString();
                try {
                    MWAValidateResponse mWAValidateResponse = activationService.validateByEntitlementId(string4, RELEASE_STRING, n, mWAMachineAttributeArray, string22, string2);
                    appLogger.logMsg("License data validated");
                    if (mWAValidateResponse.getState() == 1) {
                        appLogger.logMsg("License requires refresh");
                        MWARefreshRightsResponse mWARefreshRightsResponse = activationService.refreshRightsByEntitlementId(string4, InstutilResourceKeys.RELEASE.getString(new Object[0]), n, mWAMachineAttributeArray, string22, string2);
                        String string3 = mWARefreshRightsResponse.getLicenseFile();
                        boolean bl2 = LicenseUtilityFactory.createDefaultLicenseUtility(new MyLicenseFileWriter(file, iO), string3, string).installLicense(new LicenseFileParserImpl());
                        if (bl2) {
                            appLogger.logMsg("License data updated");
                        } else {
                            appLogger.logMsg("Error updating license file");
                            bl = false;
                        }
                    } else {
                        appLogger.logMsg("No data refresh required");
                    }
                }
                catch (Exception exception) {
                    throw new UpdateLicenseException(exception);
                }
                return bl;
            }
        };
        return (Boolean)new InstallerWorkSpace().executeTask(task, file.getAbsolutePath());
    }

    private static class MyLicenseFileWriter
    implements LicenseFileWriter {
        private final File destinationFolder;
        private IO io;

        public MyLicenseFileWriter(File file, IO iO) {
            this.destinationFolder = file;
            this.io = iO;
        }

        @Override
        public String getRootDir() {
            return this.destinationFolder.getAbsolutePath();
        }

        @Override
        public void exception(Throwable throwable, boolean bl) {
            throwable.printStackTrace();
        }

        @Override
        public Machine getMachineInfo() {
            return machineInfo;
        }

        @Override
        public String getUName() {
            return machineInfo.getUName();
        }

        @Override
        public String getHostName() {
            return machineInfo.getHostName();
        }

        @Override
        public void setMachineInfo(Machine machine) {
        }

        @Override
        public FilePermissions getFilePermissionsUtility() {
            FilePermissionsUtil filePermissionsUtil = null;
            try {
                filePermissionsUtil = new FilePermissionsUtil(libDir.getAbsolutePath());
            }
            catch (JNIException jNIException) {
                jNIException.printStackTrace();
            }
            return filePermissionsUtil;
        }

        @Override
        public boolean isNetworkBased(String string) {
            return false;
        }

        @Override
        public boolean isNetworkClient(LicenseFileParser licenseFileParser, String string) {
            return false;
        }

        @Override
        public boolean isNetworkServer() {
            return false;
        }

        @Override
        public void sendMessage(String string, String string2) {
        }

        @Override
        public LicenseLocationFactory getLicenseLocationFactory() {
            return new LicenseLocationFactoryImpl();
        }

        @Override
        public String getEthernetAddress() {
            return machineInfo.getEthernetAddress();
        }

        @Override
        public String getIpAddress() {
            return machineInfo.getIpAddress();
        }

        @Override
        public IO getIO() {
            return this.io;
        }
    }

    private static class InstallerWorkSpace<V> {
        private InstallerWorkSpace() {
        }

        private static Injector createInjector(final File file) {
            return Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(Platform.class).toInstance((Object)new PlatformImpl());
                    this.bind(AppLogger.class).toInstance((Object)new AppLoggerImpl());
                    this.bind(ProxyConfiguration.class).toInstance((Object)new ProxyConfiguration(){

                        public boolean accept(ProxyConfigurationVisitor proxyConfigurationVisitor) {
                            return false;
                        }

                        public Proxy findProxyForURL(URL uRL) {
                            return null;
                        }
                    });
                    this.bind(ActivationService.class).to(ActivationServiceProxy.class).in(Scopes.SINGLETON);
                }

                @Provides
                File getLibDirectory(Platform platform) {
                    return new File(platform.getNativeLibraryPath(file.getAbsolutePath()));
                }

                @Provides
                MachineInfo providesMachine(File file2) throws JNIException {
                    return new MachineInfo(file2.getAbsolutePath());
                }

                @Provides
                FileIO provideFileIO() {
                    return new FileIO(new FilePermissionsUtil());
                }
            }});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private V executeTask(Task<V> task, String string) throws UpdateLicenseException {
            File file = new File(string);
            Injector injector = InstallerWorkSpace.createInjector(file);
            libDir = (File)injector.getInstance(File.class);
            UpdateLicenseUtility.machineInfo = (MachineInfo)injector.getInstance(MachineInfo.class);
            ActivationService activationService = (ActivationService)injector.getInstance(ActivationService.class);
            FileIO fileIO = (FileIO)injector.getInstance(FileIO.class);
            UpdateLicenseUtility.appLogger = (AppLogger)injector.getInstance(AppLogger.class);
            try {
                V v = task.execute(file, activationService, fileIO, machineInfo);
                return v;
            }
            finally {
                appLogger.close();
            }
        }
    }

    private static interface Task<V> {
        public V execute(File var1, ActivationService var2, IO var3, MachineInfo var4) throws UpdateLicenseException;
    }
}

