/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.URLConnectionFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public final class URLConnectionFactoryImpl
implements URLConnectionFactory {
    private static final String COOKIE = "Cookie";
    private static final String LOCATION = "Location";
    private static final String SET_COOKIE = "Set-Cookie";
    static final int CONNECT_TIMEOUT = 20000;
    static final int READ_TIMEOUT = 20000;
    int MAXIMUM_REDIRECTS = 5;

    @Override
    public URLConnection createURLConnection(URL uRL, Proxy proxy, long l) throws IOException {
        URLConnection uRLConnection = uRL.openConnection(proxy);
        uRLConnection.setReadTimeout(20000);
        uRLConnection.setConnectTimeout(20000);
        uRLConnection.connect();
        return uRLConnection;
    }

    @Override
    public URLConnection createURLConnection(URL uRL, Proxy proxy, long l, long l2) throws IOException {
        URLConnection uRLConnection = uRL.openConnection(proxy);
        uRLConnection.setRequestProperty("Range", "bytes=" + l + '-' + (l2 > 0L ? Long.valueOf(l2) : ""));
        uRLConnection.setReadTimeout(20000);
        uRLConnection.setConnectTimeout(20000);
        uRLConnection.connect();
        return uRLConnection;
    }

    @Override
    public HttpURLConnection createHttpURLConnectionWithHeadRequest(URL uRL, Proxy proxy, long l) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
        httpURLConnection.setRequestMethod("HEAD");
        httpURLConnection.setReadTimeout(20000);
        httpURLConnection.setConnectTimeout(20000);
        httpURLConnection.connect();
        return httpURLConnection;
    }

    @Override
    public HttpURLConnection createHttpURLConnection(URL uRL, Proxy proxy) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
        httpURLConnection.setReadTimeout(20000);
        httpURLConnection.setConnectTimeout(20000);
        httpURLConnection.connect();
        int n = this.MAXIMUM_REDIRECTS;
        while (this.isRedirect(httpURLConnection.getResponseCode())) {
            if (n-- > 0) {
                httpURLConnection = this.followRedirect(httpURLConnection, proxy);
                continue;
            }
            httpURLConnection.disconnect();
            throw new IOException("Redirect Error: Maximum redirects reached");
        }
        return httpURLConnection;
    }

    private HttpURLConnection followRedirect(HttpURLConnection httpURLConnection, Proxy proxy) throws IOException {
        String string = httpURLConnection.getHeaderField(LOCATION);
        UrlWrapper urlWrapper = new UrlWrapper(string);
        if (this.isProtocolDowngrade(httpURLConnection.getURL(), urlWrapper.getUrl())) {
            throw new IOException("Redirect Error: https to http");
        }
        HttpURLConnection httpURLConnection2 = (HttpURLConnection)urlWrapper.openConnection(proxy);
        String string2 = httpURLConnection.getHeaderField(SET_COOKIE);
        httpURLConnection2.setRequestProperty(COOKIE, string2);
        httpURLConnection2.setReadTimeout(20000);
        httpURLConnection2.setConnectTimeout(20000);
        httpURLConnection2.connect();
        httpURLConnection.disconnect();
        return httpURLConnection2;
    }

    private boolean isRedirect(int n) {
        return n >= 301 && n <= 303;
    }

    private boolean isProtocolDowngrade(URL uRL, URL uRL2) {
        String string = uRL.getProtocol();
        String string2 = uRL2.getProtocol();
        return "https".equals(string) && "http".equals(string2);
    }

    static class UrlWrapper {
        private URL url = null;

        UrlWrapper(String string) {
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }

        URL getUrl() {
            return this.url;
        }

        String getProtocol() {
            return this.url.getProtocol();
        }

        URLConnection openConnection(Proxy proxy) throws IOException {
            return this.url.openConnection(proxy);
        }
    }
}

