/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.Arch;
import com.mathworks.instutil.DefaultSecurityOverrideImpl;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.LocalizedHelpPathFinderImpl;
import com.mathworks.instutil.MacSecurityOverrideImpl;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.SecurityOverride;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.WindowsSecurityOverride;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PlatformImpl
implements Platform {
    public static final String WINDOWS7_VERSION = "6.1";
    public static final String WINDOWS8_VERSION = "6.2";
    private Map<String, String> platformMap = new HashMap<String, String>();

    public PlatformImpl() {
        this.platformMap.put(Arch.WIN64.getString(), "Windows");
        this.platformMap.put(Arch.GLNXA64.getString(), "Linux");
        this.platformMap.put(Arch.MACI64.getString(), "macOS");
    }

    @Override
    public boolean isMac() {
        return this.getOsName().startsWith("Mac OS");
    }

    @Override
    public boolean isWindows() {
        return this.getOsName().startsWith("Windows");
    }

    @Override
    public boolean isCJK() {
        return PlatformImpl.getDefaultLanguage().equals(Locale.JAPANESE.getLanguage()) || PlatformImpl.getDefaultLanguage().equals(Locale.CHINESE.getLanguage()) || PlatformImpl.getDefaultLanguage().equals(Locale.KOREAN.getLanguage());
    }

    private static String getDefaultLanguage() {
        Locale locale = Locale.getDefault();
        return locale.getLanguage();
    }

    @Override
    public boolean isLinux() {
        return !this.isWindows() && !this.isMac();
    }

    @Override
    public String getArchString() {
        return this.getArch().getString();
    }

    @Override
    public String getArchStringForDisplay() {
        return this.platformMap.get(this.getArch().getString());
    }

    @Override
    public int getMaxPathLength() {
        if (this.isWindows7OrAbove()) {
            return 2047;
        }
        if (this.isWindows()) {
            return 1023;
        }
        return Integer.MAX_VALUE;
    }

    private boolean isWindows7OrAbove() {
        return this.isWindowsVersionAtLeast(WINDOWS7_VERSION);
    }

    @Override
    public boolean isWindows8OrAbove() {
        return this.isWindowsVersionAtLeast(WINDOWS8_VERSION);
    }

    private boolean isWindowsVersionAtLeast(String string) {
        return this.isWindows() && VersionUtils.compareVersionNumbers(System.getProperty("os.version"), string) >= 0;
    }

    private String getOsName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getNativeLibraryPath(String string) {
        return this.getBinArchFolder(string).getAbsolutePath();
    }

    private File getBinArchFolder(String string) {
        return new File(PlatformImpl.getBinFolder(string), this.getArchString());
    }

    private static File getBinFolder(String string) {
        return new File(string, "bin");
    }

    public Arch getArch() {
        Arch arch = this.isWindows() ? (this.is64Bit() ? Arch.WIN64 : Arch.WIN32) : (this.isMac() ? Arch.MACI64 : Arch.GLNXA64);
        return arch;
    }

    @Override
    public boolean is64Bit() {
        return "64".equals(System.getProperty("sun.arch.data.model"));
    }

    @Override
    public SecurityOverride getSecurityOverride(String string) {
        try {
            if (this.isWindows()) {
                return new WindowsSecurityOverride(this.getNativeLibraryPath(string));
            }
            if (this.isMac()) {
                return new MacSecurityOverrideImpl(this.getNativeLibraryPath(string));
            }
        }
        catch (JNIException jNIException) {
            // empty catch block
        }
        return new DefaultSecurityOverrideImpl();
    }

    @Override
    public String getLocalizedHelpPath(String string, String string2) {
        MessageFormat messageFormat = new MessageFormat(string);
        String string3 = messageFormat.format(new Object[]{""});
        String string4 = new File(string2, string3).getAbsolutePath();
        LocalizedHelpPathFinderImpl localizedHelpPathFinderImpl = new LocalizedHelpPathFinderImpl(string, string2);
        if (localizedHelpPathFinderImpl.localizedFileExists()) {
            return localizedHelpPathFinderImpl.getAcceptedFilePath();
        }
        return string4;
    }
}

