/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.DisplayProperties;
import com.mathworks.instutil.DisplayPropertiesImpl;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.RegistryImpl;
import com.mathworks.instutil.system.HostIdProvider;
import com.mathworks.instutil.system.HostIdProviderImpl;
import com.mathworks.internal.activationws.client.MWAMachineAttribute;
import com.mathworks.mlwebservices.MachineAttributeId;
import java.util.ArrayList;
import java.util.Collection;

public class MachineInfo
implements Machine {
    private final HostIdProvider hostIdProvider;
    private final Registry registry;
    private final boolean isHighContrast;
    private MWAMachineAttribute[] machineAttributes;
    private String userName;

    public MachineInfo(String string) throws JNIException {
        this(new HostIdProviderImpl(string), new RegistryImpl(string), new DisplayPropertiesImpl(string));
    }

    MachineInfo(HostIdProvider hostIdProvider, Registry registry, DisplayProperties displayProperties) {
        this.hostIdProvider = hostIdProvider;
        this.registry = registry;
        this.isHighContrast = displayProperties.isHighContrast();
        this.init();
    }

    @Override
    public MWAMachineAttribute[] getMachineAttributes() {
        return (MWAMachineAttribute[])this.machineAttributes.clone();
    }

    @Override
    public String[] getEthernetAddresses() {
        return this.hostIdProvider.getEthernetAddresses();
    }

    @Override
    public String getEthernetAddress() {
        return this.hostIdProvider.getEthernetAddress();
    }

    @Override
    public String getDiskSerialNumber() {
        return this.hostIdProvider.getDiskSerialNumber();
    }

    @Override
    public String getIpAddress() {
        return this.hostIdProvider.getIpAddress();
    }

    @Override
    public String getHostName() {
        return this.hostIdProvider.getHostName();
    }

    @Override
    public String getUName() {
        return this.userName;
    }

    private void init() {
        ArrayList<MWAMachineAttribute> arrayList = new ArrayList<MWAMachineAttribute>();
        this.addDiskSerialNumber(arrayList);
        this.addEthernetAddresses(arrayList);
        this.machineAttributes = arrayList.toArray(new MWAMachineAttribute[arrayList.size()]);
        this.userName = MachineInfo.GetUserName();
    }

    private void addDiskSerialNumber(Collection<MWAMachineAttribute> collection) {
        String string = this.getDiskSerialNumber();
        if (MachineInfo.isValidDiskSerialNumber(string)) {
            MWAMachineAttribute mWAMachineAttribute = new MWAMachineAttribute();
            mWAMachineAttribute.setAttr(MachineAttributeId.DISK_SERIAL_NUMBER.getValue());
            mWAMachineAttribute.setValue(string);
            collection.add(mWAMachineAttribute);
        }
    }

    private static boolean isValidDiskSerialNumber(String string) {
        return null != string && !"".equalsIgnoreCase(string) && !"0".equalsIgnoreCase(string);
    }

    private void addEthernetAddresses(Collection<MWAMachineAttribute> collection) {
        for (String string : this.getEthernetAddresses()) {
            MWAMachineAttribute mWAMachineAttribute = new MWAMachineAttribute();
            mWAMachineAttribute.setAttr(MachineAttributeId.MAC_ADDRESS.getValue());
            mWAMachineAttribute.setValue(string);
            collection.add(mWAMachineAttribute);
        }
    }

    @Override
    public String getLockingString() {
        return this.hostIdProvider.getLockingString();
    }

    private static String GetUserName() {
        return System.getProperty("user.name");
    }

    public static String getArch() {
        return new PlatformImpl().getArchString();
    }

    public static String attributesToString(MWAMachineAttribute[] mWAMachineAttributeArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MWAMachineAttribute mWAMachineAttribute : mWAMachineAttributeArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(mWAMachineAttribute.getAttr()).append("->").append(mWAMachineAttribute.getValue());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isHighContrast() {
        return this.isHighContrast;
    }

    @Override
    public boolean isValidUser(String string) {
        return this.nativeIsValidUser(string);
    }

    @Override
    public String getMatchingLockingString(String[] stringArray) {
        for (String string : stringArray) {
            if (this.getIpAddress().equalsIgnoreCase(string)) {
                return string;
            }
            for (String string2 : this.getEthernetAddresses()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string;
            }
            if (!this.diskSerialNumberMatches(string)) continue;
            return string;
        }
        return "";
    }

    private boolean diskSerialNumberMatches(String string) {
        return MachineInfo.isValidDiskSerialNumber(this.getDiskSerialNumber()) && MachineInfo.stripZeroPadding(this.getDiskSerialNumber()).equalsIgnoreCase(MachineInfo.stripZeroPadding(string));
    }

    private static String stripZeroPadding(String string) {
        String string2 = string;
        while (string2.startsWith("0") && string2.length() > 1) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private native boolean nativeIsValidUser(String var1);

    @Override
    public String getRegKeyValue(String string, String string2, String string3) {
        return this.registry.getRegKeyValue(string, string2, string3);
    }

    @Override
    public void setRegKeyValue(String string, String string2, String string3, String string4) {
        this.registry.setRegKeyValue(string, string2, string3, string4);
    }

    @Override
    public void createRegKey(String string, String string2) {
        this.registry.createRegKey(string, string2);
    }

    @Override
    public int deleteRegKey(String string, String string2) {
        return this.registry.deleteRegKey(string, string2);
    }

    @Override
    public void deleteRegKeyIfValueMatches(String string, String string2, String string3, String string4) {
        this.registry.deleteRegKeyIfValueMatches(string, string2, string3, string4);
    }
}

