/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.ResourceLocaleFactory;
import com.mathworks.instutil.VersionInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public enum InstutilResourceKeys {
    TRADEMARK("trademark.text"),
    RELEASE("releasenum.text"),
    RELEASE_DESCRIPTION("releasedescription.text"),
    PASSCODE("passcodeversion.text"),
    MATLABVERSION("matlabversion.text"),
    MPSVERSION("mpsversion.text"),
    BFDVERSION("bfdversion.text"),
    BFSVERSION("bfdversion.text"),
    CHECKSUM("exception.checksum"),
    DIALOGTITLE("dialog.title"),
    DIALOGSERVICE("dialog.service"),
    DIALOGLICENSE("dialog.license"),
    DIALOGACTIVATE("dialog.activate"),
    DIALOGCANTACTIVATE("dialog.canactivate"),
    DIALOGPROXY("dialog.proxy"),
    DIALOGREQPROPS("dialog.requiredProperties"),
    DIALOGGETLEU("dialog.getLicensedEndUser"),
    SERVERLINEEXCEPTION("exception.serverline"),
    SERVERLINEXCTITLE("exception.serverline.title"),
    LICENSEERRORTITLE("error.license.title"),
    LICENSEERRORTITLE2("error.license.title2"),
    LICENSEERROR("error.license"),
    LICENSEDIRERROR("error.license.dir"),
    LICENSEFILEERROR("error.license.file"),
    PERMISSIONERRROR("error.permissions.notset"),
    CLIENTTEMPLATE("client_template"),
    OPTIONSFILECOMMENT("optionsFile"),
    OPTIONSFILEINCLUDE("optionsFile.includeline"),
    BROWSER_ERROR_TITLE("error.browser.title"),
    BROWSER_ERROR_MESSAGE("error.browser.message"),
    X64_ARCH("x64.arch"),
    PROFESSIONAL_USAGE_STRING("professional.usage"),
    MARKERFILE_PATH("markerfile.path"),
    MARKERFILE_NAME("markerfile.name"),
    PLATFORM_DISPLAY_NAME_WIN64("platform.display.name.win64"),
    PLATFORM_DISPLAY_NAME_MACI64("platform.display.name.maci64"),
    PLATFORM_DISPLAY_NAME_GLNXA64("platform.display.name.glnxa64"),
    CONTEXT_CUT("text.Cut"),
    CONTEXT_COPY("text.Copy"),
    CONTEXT_PASTE("text.Paste"),
    CONTEXT_SELECT_ALL("text.SelectAll"),
    EMAIL_VERIFICATION_TITLE("email_verification.title"),
    EMAIL_VERIFICATION_MESSAGE("email_verification.label.boxed"),
    PRINT_ERROR_TITLE("print.error.title"),
    PRINT_ERROR_MESSAGE("print.error"),
    PROXY_AUTHENTICATION_TOP_LABEL("proxy.authentication.text"),
    PROXY_USER_LABEL("proxy.authentication.label.user"),
    PROXY_PASSWORD_LABEL("proxy.authentication.label.password"),
    PROXY_AUTHENTICATION_TITLE("proxy.authentication.title"),
    ERROR_LICENSEFILE_TITLE("licensefile.error.title"),
    ERROR_LICENSEFILE_EXCEPTION("licensefile.error.exception"),
    ERROR_LICENSEFILE_FOLDER("licensefile.error.folder"),
    ERROR_CREATING_OUTPUTFILE("error.creating.outputfile"),
    DEFAULT_LOG_FILE_NAME("default.log.file.name"),
    ERROR_CREATING_DEFAULT_OUTPUTFILE("error.creating.default.output.file");

    public static final String VERSION_INFO = "VersionInfo.xml";
    private static String matlabroot;
    private static String releaseDescription;
    private String resourceKey;
    private static final String[] PROP_SEARCH_PATH;

    private InstutilResourceKeys(String string2) {
        this.resourceKey = string2;
    }

    public String getString(Object ... objectArray) {
        return MessageFormat.format(this.getBundleString(), objectArray);
    }

    public String getBundleString() {
        String string = null;
        PlatformImpl platformImpl = new PlatformImpl();
        for (String string2 : PROP_SEARCH_PATH) {
            try {
                string = ResourceLocaleFactory.createResourceLocale(platformImpl).getBundle(string2).getString(this.resourceKey);
            }
            catch (MissingResourceException missingResourceException) {
                if (!this.resourceKey.equals("releasedescription.text")) continue;
                string = releaseDescription;
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getKey() {
        return this.resourceKey;
    }

    static {
        try {
            Path path = Paths.get(InstutilResourceKeys.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            while ((path = path.getParent()) != null) {
                if (!Files.exists(Paths.get(path.toString(), VERSION_INFO), new LinkOption[0])) continue;
                matlabroot = path.toString();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        releaseDescription = VersionInfo.getCurrentUpdateLevel(matlabroot);
        int n = releaseDescription.indexOf("_Update");
        if (n != -1) {
            releaseDescription = releaseDescription.substring(0, n);
        }
        PROP_SEARCH_PATH = new String[]{"com.mathworks.instutil.resources.RES_generated_props", "com.mathworks.instutil.resources.RES_instutil", "com.mathworks.instutil.resources.RES_instutil_notranslation"};
    }
}

